/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.compose.planner.Tools;
import com.simibubi.mightyarchitect.control.helpful.ShaderManager;
import com.simibubi.mightyarchitect.control.helpful.Shaders;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.phase.IRenderGameOverlay;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import com.simibubi.mightyarchitect.gui.ToolSelectionScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class PhaseComposing
extends PhaseBase
implements IRenderGameOverlay {
    private Tools activeTool;
    private ToolSelectionScreen toolSelection;

    @Override
    public void whenEntered() {
        Consumer<Tools> callback = tool -> this.equipTool((Tools)((Object)tool));
        this.activeTool = Tools.Room;
        this.activeTool.getTool().init();
        List<Tools> groundPlanningTools = Tools.getGroundPlanningTools();
        if (!this.getModel().getTheme().getStatistics().hasTowers) {
            groundPlanningTools.remove((Object)Tools.Cylinder);
        }
        this.toolSelection = new ToolSelectionScreen(groundPlanningTools, callback);
        ShaderManager.setActiveShader(Shaders.Blueprint);
    }

    private void equipTool(Tools tool) {
        if (tool == this.activeTool) {
            return;
        }
        this.activeTool = tool;
        this.activeTool.getTool().init();
    }

    @Override
    public void update() {
        this.activeTool.getTool().updateSelection();
        this.toolSelection.update();
    }

    @Override
    public void onClick(int button) {
        if (button == 1) {
            String message = this.activeTool.getTool().handleRightClick();
            this.sendStatusMessage(message);
        }
    }

    @Override
    public void onKey(int key, boolean released) {
        if (key != TheMightyArchitect.TOOL_MENU.getKey().func_197937_c()) {
            return;
        }
        if (released && this.toolSelection.focused) {
            this.toolSelection.focused = false;
            this.toolSelection.onClose();
        }
        if (!released && !this.toolSelection.focused) {
            this.toolSelection.focused = true;
        }
    }

    @Override
    public boolean onScroll(int amount) {
        if (this.toolSelection.focused) {
            this.toolSelection.cycle(amount);
            return true;
        }
        return this.activeTool.getTool().handleMouseWheel(amount);
    }

    @Override
    public void render() {
        TessellatorHelper.prepareForDrawing();
        this.activeTool.getTool().renderGroundPlan();
        this.activeTool.getTool().renderTool();
        TessellatorHelper.cleanUpAfterDrawing();
    }

    @Override
    public void whenExited() {
        ShaderManager.stopUsingShaders();
    }

    @Override
    public void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        this.toolSelection.renderPassive(event.getPartialTicks());
        this.activeTool.getTool().renderOverlay();
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Draw the layout of your build, adding rooms, towers and other. Modify their position, size and roof using the Tools.");
    }
}

