/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorTextures;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.phase.IDrawBlockHighlights;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PhaseCreatingPalette
extends PhaseBase
implements IDrawBlockHighlights {
    private PaletteDefinition palette;
    private BlockPos center;
    private Map<BlockPos, Palette> grid;
    private boolean[] changed;

    @Override
    public void whenEntered() {
        Schematic model = this.getModel();
        ClientWorld world = this.minecraft.field_71441_e;
        this.changed = new boolean[16];
        this.palette = model.getCreatedPalette();
        this.center = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, this.minecraft.field_71439_g.func_180425_c());
        this.grid = new HashMap<BlockPos, Palette>();
        for (int i = 0; i < 16; ++i) {
            BlockPos pos = this.positionFromIndex(i);
            this.grid.put(pos, Palette.values()[i]);
            if (world.func_175623_d(pos) || this.palette.get(Palette.values()[i]) == world.func_180495_p(pos)) continue;
            this.palette.put(Palette.values()[i], world.func_180495_p(pos));
            this.changed[i] = true;
        }
        model.updatePalettePreview();
        SchematicHologram.display(this.getModel());
    }

    @Override
    public void update() {
        for (int i = 0; i < 16; ++i) {
            BlockPos pos = this.positionFromIndex(i);
            if (this.minecraft.field_71441_e.func_175623_d(pos)) {
                Palette key;
                PaletteDefinition paletteDef = this.getModel().isEditingPrimary() ? this.getModel().getPrimary() : this.getModel().getSecondary();
                if (paletteDef.get(key = this.grid.get(pos)) == this.palette.get(key)) continue;
                this.palette.put(key, paletteDef.get(key));
                this.changed[i] = false;
                this.notifyChange();
                continue;
            }
            BlockState state = this.minecraft.field_71441_e.func_180495_p(pos);
            if (state.func_177230_c() instanceof TrapDoorBlock) {
                state = (BlockState)state.func_206870_a((IProperty)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(true));
            }
            if (this.palette.get(Palette.values()[i]) == state) continue;
            this.palette.put(this.grid.get(pos), state);
            this.changed[i] = true;
            this.notifyChange();
        }
    }

    @Override
    public void render() {
        int i;
        TessellatorHelper.prepareForDrawing();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (i = 0; i < 16; ++i) {
            BlockState state = this.palette.get(Palette.values()[i]);
            if (state == null || this.changed[i]) continue;
            GlStateManager.pushMatrix();
            BlockPos translate = this.positionFromIndex(i);
            this.minecraft.func_175602_ab().renderBlock(state, translate, (IEnviromentBlockReader)this.minecraft.field_71441_e, bufferBuilder, this.minecraft.field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
            GlStateManager.popMatrix();
        }
        Tessellator.func_178181_a().func_78381_a();
        TessellatorTextures.PaletteChanged.bind();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < 16; ++i) {
            if (!this.changed[i]) continue;
            TessellatorHelper.cube(bufferBuilder, this.positionFromIndex(i), new BlockPos(1, 1, 1), 0.03125, true, true);
        }
        Tessellator.func_178181_a().func_78381_a();
        TessellatorTextures.PaletteUnchanged.bind();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < 16; ++i) {
            if (this.changed[i]) continue;
            TessellatorHelper.cube(bufferBuilder, this.positionFromIndex(i), new BlockPos(1, 1, 1), 0.03125, true, true);
        }
        Tessellator.func_178181_a().func_78381_a();
        TessellatorHelper.cleanUpAfterDrawing();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
    }

    @Override
    public void whenExited() {
        this.getModel().stopPalettePreview();
        SchematicHologram.reset();
    }

    protected void notifyChange() {
        this.getModel().updatePalettePreview();
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Updating Preview..."), true);
        SchematicHologram.getInstance().schematicChanged();
    }

    @Override
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        BlockPos targetBlock;
        RayTraceResult raytrace = event.getTarget();
        if (raytrace != null && raytrace.func_216346_c() == RayTraceResult.Type.BLOCK && this.grid.containsKey(targetBlock = new BlockPos(raytrace.func_216347_e()))) {
            TessellatorHelper.prepareForDrawing();
            TessellatorHelper.drawString(this.grid.get(targetBlock).getDisplayName(), (float)targetBlock.func_177958_n() + 0.5f, (float)targetBlock.func_177984_a().func_177956_o() + 0.3f, (float)targetBlock.func_177952_p() + 0.5f, false, true);
            TessellatorHelper.cleanUpAfterDrawing();
        }
    }

    private BlockPos positionFromIndex(int index) {
        return this.center.func_177965_g(-3 + index % 4 * 2).func_177970_e(-3 + index / 4 * 2);
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"The Ghost blocks show the individual materials used in this build.", (Object)"Modify the palette by placing blocks into the marked areas. You do not have to fill all the gaps.", (Object)"Once finished, make sure to save it. [F]");
    }
}

