/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.compose.planner.Tools;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.phase.IRenderGameOverlay;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import com.simibubi.mightyarchitect.gui.ToolSelectionScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class PhasePreviewing
extends PhaseBase
implements IRenderGameOverlay {
    private Tools activeTool;
    private ToolSelectionScreen toolSelection;

    @Override
    public void whenEntered() {
        Consumer<Tools> callback = tool -> this.equipTool((Tools)((Object)tool));
        this.activeTool = Tools.RerollAll;
        this.activeTool.getTool().init();
        List<Tools> tools = Tools.getWallDecorationTools();
        this.toolSelection = new ToolSelectionScreen(tools, callback);
        SchematicHologram.display(this.getModel());
    }

    private void equipTool(Tools tool) {
        if (tool == this.activeTool) {
            return;
        }
        this.activeTool = tool;
        this.activeTool.getTool().init();
    }

    @Override
    public void onClick(int button) {
        if (button == 1 && Minecraft.func_71410_x().field_71462_r == null) {
            String message = this.activeTool.getTool().handleRightClick();
            this.sendStatusMessage(message);
        }
    }

    @Override
    public void onKey(int key, boolean released) {
        if (key != TheMightyArchitect.TOOL_MENU.getKey().func_197937_c()) {
            return;
        }
        if (released && this.toolSelection.focused) {
            this.toolSelection.focused = false;
            this.toolSelection.onClose();
        }
        if (!released && !this.toolSelection.focused) {
            this.toolSelection.focused = true;
        }
    }

    @Override
    public void update() {
        this.activeTool.getTool().updateSelection();
        this.toolSelection.update();
    }

    @Override
    public boolean onScroll(int amount) {
        if (this.toolSelection.focused) {
            this.toolSelection.cycle(amount);
            return true;
        }
        return this.activeTool.getTool().handleMouseWheel(amount);
    }

    @Override
    public void render() {
        TessellatorHelper.prepareForDrawing();
        this.activeTool.getTool().renderGroundPlan();
        this.activeTool.getTool().renderTool();
        TessellatorHelper.cleanUpAfterDrawing();
    }

    @Override
    public void whenExited() {
        SchematicHologram.reset();
    }

    @Override
    public void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        this.toolSelection.renderPassive(event.getPartialTicks());
        this.activeTool.getTool().renderOverlay();
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Here is a preview of your new build.", (Object)"From here you can pick your materials in the palette picker [C]", (Object)"Once you are happy with what you see, save or build your structure.");
    }
}

