/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase.export;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.helpful.BuildingHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorTextures;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;

public class PhaseEditTheme
extends PhaseBase {
    public static Cuboid selectedDesign;
    public static Cuboid effectiveSelectedDesign;
    public static int effectiveHeight;
    public String frontText;
    public String rightText;
    public String backText;
    public String leftText;
    private DesignType lastType;

    @Override
    public void whenEntered() {
        selectedDesign = null;
        effectiveSelectedDesign = null;
        this.frontText = null;
        this.rightText = null;
        this.leftText = null;
        this.backText = null;
        this.lastType = null;
        effectiveHeight = 0;
    }

    @Override
    public void update() {
        if (this.lastType == DesignExporter.type) {
            return;
        }
        this.frontText = null;
        this.rightText = null;
        this.leftText = null;
        this.backText = null;
        this.lastType = DesignExporter.type;
        switch (this.lastType) {
            case CORNER: {
                this.frontText = "Facade";
                this.rightText = "Side Facade";
                break;
            }
            case FACADE: 
            case WALL: {
                this.frontText = "Facade";
                this.backText = "Back";
                break;
            }
            case FLAT_ROOF: {
                this.frontText = "Front";
                this.rightText = "Back";
                this.backText = "Back";
                this.leftText = "Front";
                break;
            }
            case ROOF: {
                this.frontText = "Facade";
                this.leftText = "Side";
                this.rightText = "Side";
                this.backText = "Back";
                break;
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                break;
            }
        }
    }

    @Override
    public void render() {
        if (selectedDesign == null) {
            return;
        }
        TessellatorHelper.prepareForDrawing();
        TessellatorTextures.Selection.bind();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Cuboid selection = selectedDesign;
        TessellatorHelper.walls(bufferBuilder, selection.getOrigin(), selection.getSize().func_177979_c(selection.height - 1), 0.0625, false, true);
        Tessellator.func_178181_a().func_78381_a();
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        WorldRenderer.func_189698_a((BufferBuilder)bufferBuilder, (double)((float)selection.x - 0.125f), (double)((float)selection.y + 0.0625f), (double)((float)selection.z - 0.125f), (double)((float)(selection.x + selection.width) + 0.125f), (double)((float)(selection.y + selection.height) + 0.0625f), (double)((float)(selection.z + selection.length) + 0.125f), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.depthMask((boolean)true);
        if (effectiveSelectedDesign != null) {
            TessellatorTextures.Exporter.bind();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            if (DesignExporter.type == DesignType.TOWER || DesignExporter.type == DesignType.TOWER_FLAT_ROOF || DesignExporter.type == DesignType.TOWER_ROOF) {
                int radius = DesignExporter.designParameter;
                BlockPos center = selection.getCenter().func_177979_c(selection.height / 2);
                for (BlockPos pos : BuildingHelper.getCircle(center, radius)) {
                    TessellatorHelper.cube(bufferBuilder, pos, BlockPos.field_177992_a.func_177982_a(1, PhaseEditTheme.effectiveSelectedDesign.height, 1), 0.03125, true, false);
                }
            } else {
                Cuboid effectiveSelection = effectiveSelectedDesign;
                TessellatorHelper.cube(bufferBuilder, effectiveSelection.getOrigin(), effectiveSelection.getSize(), 0.03125, true, false);
            }
            Tessellator.func_178181_a().func_78381_a();
        }
        if (this.backText != null) {
            TessellatorHelper.drawString(this.backText, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z - 1, false, false);
        }
        if (this.frontText != null) {
            TessellatorHelper.drawString(this.frontText, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z + selection.length + 1, false, false);
        }
        if (this.rightText != null) {
            TessellatorHelper.drawString(this.rightText, selection.x + selection.width + 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, false, false);
        }
        if (this.leftText != null) {
            TessellatorHelper.drawString(this.leftText, selection.x - 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, false, false);
        }
        TessellatorHelper.cleanUpAfterDrawing();
    }

    @Override
    public void whenExited() {
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Right click the origin marker of your designs to scan them.", (Object)"Don't forget to pick the correct traits (type, layer, size) for the next design!");
    }

    public static void setVisualization(Cuboid bounds) {
        selectedDesign = bounds;
        effectiveSelectedDesign = null;
        if (selectedDesign == null) {
            return;
        }
        switch (DesignExporter.type) {
            case CORNER: {
                effectiveSelectedDesign = new Cuboid(selectedDesign.getOrigin(), 1, PhaseEditTheme.selectedDesign.height, 1);
                break;
            }
            case FACADE: 
            case WALL: {
                effectiveSelectedDesign = new Cuboid(selectedDesign.getOrigin(), PhaseEditTheme.selectedDesign.width, PhaseEditTheme.selectedDesign.height, 1);
                break;
            }
            case FLAT_ROOF: {
                int margin = DesignExporter.designParameter;
                effectiveSelectedDesign = new Cuboid(selectedDesign.getOrigin().func_177965_g(margin), selectedDesign.getSize().func_177982_a(-margin, 0, -margin));
                break;
            }
            case ROOF: {
                int span = DesignExporter.designParameter;
                int margin = (PhaseEditTheme.selectedDesign.width - span) / 2;
                effectiveSelectedDesign = new Cuboid(selectedDesign.getOrigin().func_177982_a(margin, 0, 0), PhaseEditTheme.selectedDesign.width - 2 * margin, PhaseEditTheme.selectedDesign.height, 3);
                break;
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                int radius = DesignExporter.designParameter;
                int margin = (PhaseEditTheme.selectedDesign.width - (radius * 2 + 1)) / 2;
                effectiveSelectedDesign = new Cuboid(selectedDesign.getOrigin().func_177982_a(margin, 0, margin), selectedDesign.getSize().func_177982_a(-2 * margin, 0, -2 * margin));
                break;
            }
        }
        PhaseEditTheme.effectiveSelectedDesign.height = effectiveHeight;
    }

    public static boolean isVisualizing() {
        return selectedDesign != null;
    }

    public static void resetVisualization() {
        selectedDesign = null;
        effectiveSelectedDesign = null;
        effectiveHeight = 0;
    }
}

