/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.phase.export.PhaseEditTheme;
import com.simibubi.mightyarchitect.gui.AbstractSimiScreen;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import com.simibubi.mightyarchitect.gui.widgets.Label;
import com.simibubi.mightyarchitect.gui.widgets.ScrollInput;
import com.simibubi.mightyarchitect.gui.widgets.SelectionScrollInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.AtlasTexture;

public class DesignExporterScreen
extends AbstractSimiScreen {
    private ScrollInput scrollAreaLayer;
    private ScrollInput scrollAreaType;
    private ScrollInput scrollAreaAdditionalData;
    private Label labelTheme;
    private Label labelLayer;
    private Label labelType;
    private Label labelAdditionalData;
    private String additionalDataKey;
    private int additionalDataValue;
    private float animationProgress;

    public void init() {
        super.init();
        this.animationProgress = 0.0f;
        this.setWindowSize(ScreenResources.EXPORTER.width + 100, ScreenResources.EXPORTER.height + 50);
        DesignTheme theme = DesignExporter.theme;
        DesignLayer layer = DesignExporter.layer;
        DesignType type = DesignExporter.type;
        this.additionalDataValue = DesignExporter.designParameter;
        this.labelTheme = new Label(this.topLeftX + 96, this.topLeftY + 28, "").withShadow();
        this.labelLayer = new Label(this.topLeftX + 96, this.topLeftY + 48, "").withShadow();
        this.labelType = new Label(this.topLeftX + 96, this.topLeftY + 68, "").withShadow();
        this.labelAdditionalData = new Label(this.topLeftX + 96, this.topLeftY + 88, "").withShadow();
        this.additionalDataKey = "";
        this.initScrollAreas(theme, layer, type);
    }

    private void initScrollAreas(DesignTheme theme, DesignLayer layer, DesignType type) {
        this.widgets.clear();
        List<DesignLayer> layers = theme.getLayers();
        this.labelTheme.text = theme.getDisplayName();
        if (!layers.contains((Object)layer)) {
            layer = DesignLayer.Regular;
        }
        ArrayList<String> layerOptions = new ArrayList<String>();
        layers.forEach(l -> layerOptions.add(l.getDisplayName()));
        this.scrollAreaLayer = new SelectionScrollInput(this.topLeftX + 93, this.topLeftY + 45, 90, 14).forOptions(layerOptions).titled("Layer").writingTo(this.labelLayer).setState(layers.indexOf((Object)layer)).calling(position -> this.initTypeScrollArea(theme, (DesignLayer)((Object)((Object)layers.get((int)position))), DesignExporter.type));
        this.widgets.add(this.labelTheme);
        this.widgets.add(this.labelLayer);
        this.widgets.add(this.labelType);
        this.widgets.add(this.labelAdditionalData);
        this.widgets.add(this.scrollAreaLayer);
        this.initTypeScrollArea(theme, layer, type);
    }

    protected void initTypeScrollArea(DesignTheme theme, DesignLayer layer, DesignType type) {
        ArrayList<DesignType> types = new ArrayList<DesignType>(theme.getTypes());
        if (layer == DesignLayer.Roofing) {
            types.retainAll(DesignType.roofTypes());
        } else {
            types.removeAll(DesignType.roofTypes());
        }
        if (!types.contains((Object)type)) {
            type = DesignType.WALL;
            if (layer == DesignLayer.Roofing) {
                for (DesignType dt : DesignType.roofTypes()) {
                    if (!types.contains((Object)dt)) continue;
                    type = dt;
                    break;
                }
            }
        }
        ArrayList<String> typeOptions = new ArrayList<String>();
        types.forEach(t -> typeOptions.add(t.getDisplayName()));
        if (this.widgets.contains((Object)this.scrollAreaType)) {
            this.widgets.remove((Object)this.scrollAreaType);
        }
        this.scrollAreaType = new SelectionScrollInput(this.topLeftX + 93, this.topLeftY + 65, 90, 14).forOptions(typeOptions).titled("Design Type").writingTo(this.labelType).setState(types.indexOf((Object)type)).calling(position -> {
            DesignExporter.type = (DesignType)((Object)((Object)types.get((int)position)));
            this.initAdditionalDataScrollArea((DesignType)((Object)((Object)types.get((int)position))));
        });
        this.widgets.add(this.scrollAreaType);
        this.initAdditionalDataScrollArea(type);
    }

    private void initAdditionalDataScrollArea(DesignType type) {
        if (this.widgets.contains((Object)this.scrollAreaAdditionalData)) {
            this.widgets.remove((Object)this.scrollAreaAdditionalData);
        }
        if (type.hasAdditionalData()) {
            this.additionalDataKey = type.getAdditionalDataName();
            if (type.hasSizeData()) {
                if (type == DesignType.ROOF && this.additionalDataValue % 2 == 0) {
                    ++this.additionalDataValue;
                }
                if (this.additionalDataValue < type.getMinSize()) {
                    this.additionalDataValue = type.getMinSize();
                }
                if (this.additionalDataValue > type.getMaxSize()) {
                    this.additionalDataValue = type.getMaxSize();
                }
                this.labelAdditionalData.text = this.additionalDataValue + "m";
                if (type == DesignType.ROOF) {
                    int min = (type.getMinSize() - 1) / 2;
                    int max = (type.getMaxSize() - 1) / 2;
                    this.scrollAreaAdditionalData = new ScrollInput(this.topLeftX + 93, this.topLeftY + 85, 90, 14).withRange(min, max).setState((this.additionalDataValue - 1) / 2).writingTo(this.labelAdditionalData).calling(position -> {
                        this.additionalDataValue = position * 2 + 1;
                        this.labelAdditionalData.text = position * 2 + 1 + "m";
                    });
                    this.labelAdditionalData.text = this.additionalDataValue + "m";
                } else {
                    int min = type.getMinSize();
                    int max = type.getMaxSize();
                    this.scrollAreaAdditionalData = new ScrollInput(this.topLeftX + 93, this.topLeftY + 85, 90, 14).withRange(min, max + 1).setState(this.additionalDataValue).writingTo(this.labelAdditionalData).calling(position -> {
                        this.additionalDataValue = position;
                        this.labelAdditionalData.text = position + "m";
                    });
                }
            } else if (type.hasSubtypes()) {
                List<String> subtypeOptions;
                if (this.additionalDataValue == -1) {
                    this.additionalDataValue = 0;
                }
                if (this.additionalDataValue >= (subtypeOptions = type.getSubtypeOptions()).size()) {
                    this.additionalDataValue = 0;
                }
                this.labelAdditionalData.text = subtypeOptions.get(this.additionalDataValue);
                this.scrollAreaAdditionalData = new SelectionScrollInput(this.topLeftX + 93, this.topLeftY + 85, 90, 14).forOptions(subtypeOptions).writingTo(this.labelAdditionalData).setState(this.additionalDataValue).calling(p -> {
                    this.additionalDataValue = p;
                });
            }
            this.scrollAreaAdditionalData.titled(this.additionalDataKey);
            this.widgets.add(this.scrollAreaAdditionalData);
        } else {
            this.additionalDataValue = -1;
            this.additionalDataKey = "";
            this.labelAdditionalData.text = "";
            this.scrollAreaAdditionalData = null;
        }
    }

    public void tick() {
        super.tick();
        this.animationProgress += 1.0f;
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        ScreenResources.EXPORTER.draw((AbstractGui)this, this.topLeftX, this.topLeftY);
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.pushLightingAttributes();
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        GlStateManager.enableBlend();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translatef((float)((this.width - this.sWidth) / 2 + 250), (float)220.0f, (float)100.0f);
        GlStateManager.rotatef((float)-30.0f, (float)0.4f, (float)0.0f, (float)-0.2f);
        GlStateManager.rotatef((float)(90.0f + 0.2f * this.animationProgress), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)100.0f, (float)-100.0f, (float)100.0f);
        this.itemRenderer.func_180454_a(this.minecraft.field_71439_g.func_184614_ca(), this.itemRenderer.func_204206_b(this.minecraft.field_71439_g.func_184614_ca()));
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        GlStateManager.popAttributes();
        int color = 5726074;
        this.font.func_211126_b("Export custom Designs", (float)(this.topLeftX + 10), (float)(this.topLeftY + 10), color);
        this.font.func_211126_b("Theme", (float)(this.topLeftX + 10), (float)(this.topLeftY + 28), color);
        this.font.func_211126_b("Building Layer", (float)(this.topLeftX + 10), (float)(this.topLeftY + 48), color);
        this.font.func_211126_b("Design Type", (float)(this.topLeftX + 10), (float)(this.topLeftY + 68), color);
        this.font.func_211126_b(this.additionalDataKey, (float)(this.topLeftX + 10), (float)(this.topLeftY + 88), color);
    }

    public void removed() {
        DesignTheme theme = DesignExporter.theme;
        DesignExporter.layer = theme.getLayers().get(this.scrollAreaLayer.getState());
        ArrayList<DesignType> types = new ArrayList<DesignType>(theme.getTypes());
        if (DesignExporter.layer == DesignLayer.Roofing) {
            types.retainAll(DesignType.roofTypes());
        } else {
            types.removeAll(DesignType.roofTypes());
        }
        DesignExporter.type = (DesignType)((Object)types.get(this.scrollAreaType.getState()));
        DesignExporter.designParameter = this.additionalDataValue;
        PhaseEditTheme.setVisualization(PhaseEditTheme.selectedDesign);
    }
}

