/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.palette.PaletteStorage;
import com.simibubi.mightyarchitect.gui.AbstractSimiScreen;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import com.simibubi.mightyarchitect.gui.widgets.IconButton;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class PalettePickerScreen
extends AbstractSimiScreen {
    private PaletteButton primary;
    private PaletteButton secondary;
    private IconButton buttonAddPalette;
    private IconButton buttonOpenFolder;
    private IconButton buttonRefresh;
    private boolean scanPicker;

    public PalettePickerScreen() {
        this(false);
    }

    public PalettePickerScreen(boolean scanPicker) {
        this.minecraft = Minecraft.func_71410_x();
        this.scanPicker = scanPicker;
    }

    public void init() {
        super.init();
        this.setWindowSize(256, 236);
        this.widgets.clear();
        this.updateSelected();
        int id = 2;
        int x = this.topLeftX + 10;
        int y = this.topLeftY + 68;
        for (String paletteName : PaletteStorage.getResourcePaletteNames()) {
            this.widgets.add(new PaletteButton(PaletteStorage.getPalette(paletteName), this, id, x + (id - 2) % 5 * 23, y + (id - 2) / 5 * 23));
            ++id;
        }
        int i = 0;
        x = this.topLeftX + 135;
        y = this.topLeftY + 68;
        for (String paletteName : PaletteStorage.getPaletteNames()) {
            this.widgets.add(new PaletteButton(PaletteStorage.getPalette(paletteName), this, id + i, x + i % 5 * 23, y + i / 5 * 23));
            ++i;
        }
        if (!this.scanPicker) {
            this.buttonAddPalette = new IconButton(x + i % 5 * 23, y + i / 5 * 23, ScreenResources.ICON_ADD);
            this.buttonAddPalette.setToolTip("Create Palette");
            this.buttonAddPalette.getToolTip().add(TextFormatting.GRAY + "Will use currently selected");
            this.buttonAddPalette.getToolTip().add(TextFormatting.GRAY + "Palette as the template.");
            ++i;
            this.widgets.add(this.buttonAddPalette);
        }
        this.buttonOpenFolder = new IconButton(x + i % 5 * 23, y + i / 5 * 23, ScreenResources.ICON_FOLDER);
        this.buttonOpenFolder.setToolTip("Open Palette Folder");
        this.widgets.add(this.buttonOpenFolder);
        this.buttonRefresh = new IconButton(x + ++i % 5 * 23, y + i / 5 * 23, ScreenResources.ICON_REFRESH);
        this.buttonRefresh.setToolTip("Refresh Imported Palettes");
        this.widgets.add(this.buttonRefresh);
        ++i;
    }

    public void removed() {
        super.removed();
        if (this.scanPicker) {
            if (this.primary.palette.hasDuplicates()) {
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Warning: Ambiguous Scanner Palette " + TextFormatting.WHITE + "( " + this.primary.palette.getDuplicates() + " )"), false);
            }
            this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Updated Default Palette"), true);
            DesignExporter.theme.setDefaultPalette(this.primary.palette);
            DesignExporter.theme.setDefaultSecondaryPalette(this.secondary.palette);
        }
    }

    private void updateSelected() {
        if (this.widgets.contains((Object)this.primary)) {
            this.widgets.remove((Object)this.primary);
        }
        if (this.widgets.contains((Object)this.secondary)) {
            this.widgets.remove((Object)this.secondary);
        }
        if (this.scanPicker) {
            this.primary = new PaletteButton(DesignExporter.scanningPalette, this, 0, this.topLeftX + 135, this.topLeftY + 8);
            this.primary.active = false;
            this.secondary = new PaletteButton(DesignExporter.theme.getDefaultSecondaryPalette(), this, 1, this.topLeftX + 192, this.topLeftY + 8);
            this.secondary.active = false;
            this.widgets.add(this.primary);
            this.widgets.add(this.secondary);
            return;
        }
        this.primary = new PaletteButton(ArchitectManager.getModel().getPrimary(), this, 0, this.topLeftX + 135, this.topLeftY + 8);
        this.primary.active = false;
        this.secondary = new PaletteButton(ArchitectManager.getModel().getSecondary(), this, 1, this.topLeftX + 192, this.topLeftY + 8);
        this.secondary.active = false;
        this.widgets.add(this.primary);
        this.widgets.add(this.secondary);
    }

    @Override
    public void renderWindow(int mouseX, int mouseY, float partialTicks) {
        ScreenResources.PALETTES.draw((AbstractGui)this, this.topLeftX, this.topLeftY);
        int color = 5726074;
        if (this.scanPicker) {
            this.font.func_211126_b("Choose a palette for", (float)(this.topLeftX + 8), (float)(this.topLeftY + 10), color);
            this.font.func_211126_b("your theme.", (float)(this.topLeftX + 8), (float)(this.topLeftY + 18), color);
        } else {
            this.font.func_211126_b("Palette Picker", (float)(this.topLeftX + 8), (float)(this.topLeftY + 10), color);
            this.font.func_211126_b("Primary", (float)(this.topLeftX + 134), (float)(this.topLeftY + 30), color);
            this.font.func_211126_b("Secondary", (float)(this.topLeftX + 191), (float)(this.topLeftY + 30), color);
        }
        this.font.func_211126_b("Included Palettes", (float)(this.topLeftX + 8), (float)(this.topLeftY + 53), color);
        this.font.func_211126_b("My Palettes", (float)(this.topLeftX + 134), (float)(this.topLeftY + 53), color);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget guibutton = (Widget)this.widgets.get(i);
            if (!guibutton.isMouseOver(mouseX, mouseY)) continue;
            guibutton.playDownSound(this.minecraft.func_147118_V());
            if (mouseButton == 0) {
                this.buttonClicked(guibutton);
            }
            if (mouseButton == 1) {
                this.buttonRightClicked(guibutton);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void buttonClicked(Widget button) {
        if (button == this.buttonOpenFolder) {
            Util.func_110647_a().func_195641_a(Paths.get("palettes/", new String[0]).toFile());
        }
        if (button == this.buttonRefresh) {
            PaletteStorage.loadAllPalettes();
            this.init();
        }
        if (this.scanPicker) {
            if (button instanceof PaletteButton) {
                DesignExporter.scanningPalette = ((PaletteButton)button).palette;
            }
            this.updateSelected();
            return;
        }
        if (!(button instanceof PaletteButton)) {
            if (button == this.buttonAddPalette) {
                ArchitectManager.createPalette(true);
                this.minecraft.func_147108_a(null);
            }
        } else {
            ArchitectManager.getModel().swapPrimaryPalette(((PaletteButton)button).palette);
            this.updateSelected();
            SchematicHologram.getInstance().schematicChanged();
        }
    }

    protected void buttonRightClicked(Widget button) {
        if (this.scanPicker) {
            if (button instanceof PaletteButton) {
                DesignExporter.theme.setDefaultSecondaryPalette(((PaletteButton)button).palette);
            }
            this.updateSelected();
            return;
        }
        if (!(button instanceof PaletteButton)) {
            ArchitectManager.createPalette(false);
            this.minecraft.func_147108_a(null);
        } else {
            ArchitectManager.getModel().swapSecondaryPalette(((PaletteButton)button).palette);
            this.updateSelected();
            SchematicHologram.getInstance().schematicChanged();
        }
    }

    class PaletteButton
    extends IconButton {
        Screen parent;
        PaletteDefinition palette;

        public PaletteButton(PaletteDefinition palette, Screen parent, int buttonId, int x, int y) {
            super(x, y, ScreenResources.ICON_NONE);
            this.parent = parent;
            this.palette = palette;
            this.visible = true;
            this.active = true;
        }

        private void drawPreview(Minecraft mc) {
            GlStateManager.pushMatrix();
            mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            GlStateManager.enableBlend();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.translatef((float)(this.x + 1), (float)(this.y + 17), (float)10.0f);
            GlStateManager.scalef((float)8.0f, (float)-8.0f, (float)8.0f);
            this.renderBlock(mc, buffer, new BlockPos(0, 1, 1), Palette.INNER_PRIMARY);
            this.renderBlock(mc, buffer, new BlockPos(1, 1, 1), Palette.INNER_DETAIL);
            this.renderBlock(mc, buffer, new BlockPos(0, 0, 0), Palette.HEAVY_PRIMARY);
            this.renderBlock(mc, buffer, new BlockPos(1, 0, 0), Palette.ROOF_PRIMARY);
            GlStateManager.popMatrix();
        }

        protected void renderBlock(Minecraft mc, BufferBuilder buffer, BlockPos pos, Palette key) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            IBakedModel model = mc.func_175602_ab().func_184389_a(this.palette.get(key));
            mc.func_175602_ab().func_175019_b().func_178266_a(model, this.palette.get(key), this.isHovered ? 1.0f : 0.9f, true);
            GlStateManager.popMatrix();
        }

        @Override
        public void renderButton(int mouseX, int mouseY, float partialTicks) {
            super.renderButton(mouseX, mouseY, partialTicks);
            this.drawPreview(PalettePickerScreen.this.minecraft);
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (this.isHovered) {
                PalettePickerScreen.this.renderTooltip(this.palette.getName(), mouseX, mouseY);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

