/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.ThemeStorage;
import com.simibubi.mightyarchitect.gui.AbstractSimiScreen;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import com.simibubi.mightyarchitect.gui.widgets.IconButton;
import com.simibubi.mightyarchitect.gui.widgets.Indicator;
import com.simibubi.mightyarchitect.gui.widgets.Label;
import com.simibubi.mightyarchitect.gui.widgets.ScrollInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ThemeSettingsScreen
extends AbstractSimiScreen {
    private DesignTheme theme = DesignExporter.theme;
    private TextFieldWidget inputName;
    private TextFieldWidget inputAuthor;
    private List<Indicator> indicators;
    private List<TextFieldWidget> inputs;
    private List<IconButton> toggleButtons;
    private IconButton confirm;
    private int regular;
    private int foundation;
    private int open;
    private int special;
    private int flatRoof;
    private int roof;
    private int tower;
    private int towerFlatRoof;
    private int towerRoof;
    private ScrollInput areaRoomHeight;
    private Label labelRoomHeight;

    public void init() {
        super.init();
        this.setWindowSize(ScreenResources.THEME_EDITOR.width, ScreenResources.THEME_EDITOR.height);
        this.toggleButtons = new ArrayList<IconButton>();
        this.inputs = new ArrayList<TextFieldWidget>();
        int x = this.topLeftX + 85;
        int y = this.topLeftY + 14;
        int id = 0;
        this.inputName = new TextFieldWidget(this.font, x, y, 104, 8, "");
        this.inputName.func_146180_a(this.theme.getDisplayName());
        this.inputName.changeFocus(false);
        this.inputs.add(this.inputName);
        this.inputAuthor = new TextFieldWidget(this.font, x, y + 20, 104, 8, "");
        this.inputAuthor.func_146180_a(this.theme.getDesigner());
        this.inputAuthor.changeFocus(false);
        this.inputs.add(this.inputAuthor);
        this.inputs.forEach(input -> {
            input.func_146193_g(-1);
            input.func_146204_h(-1);
            input.func_146185_a(false);
            input.func_146203_f(35);
            input.changeFocus(false);
        });
        this.indicators = new ArrayList<Indicator>();
        x = this.topLeftX + 10;
        y = this.topLeftY + 75;
        int indexShift = -id;
        this.regular = id++ + indexShift;
        IconButton button = new IconButton(x, y, ScreenResources.ICON_LAYER_REGULAR);
        button.setToolTip("Regular Style [Always enabled]");
        this.toggleButtons.add(button);
        Indicator guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = Indicator.State.YELLOW;
        this.indicators.add(guiIndicator);
        this.foundation = id++ + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_LAYER_FOUNDATION);
        button.setToolTip("Foundation Style");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getLayers().contains((Object)DesignLayer.Foundation) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.open = id++ + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_LAYER_OPEN);
        button.setToolTip("Open Arcs Style");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getLayers().contains((Object)DesignLayer.Open) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.special = id++ + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_LAYER_SPECIAL);
        button.setToolTip("Special Layer");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getLayers().contains((Object)DesignLayer.Special) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        x = this.topLeftX + 10;
        button = new IconButton(x, y += 49, ScreenResources.ICON_NO_ROOF);
        button.setToolTip("Enable Rooms [Always Enabled]");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = Indicator.State.YELLOW;
        this.indicators.add(guiIndicator);
        int n = ++id;
        ++id;
        this.flatRoof = n + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_FLAT_ROOF);
        button.setToolTip("Flat Roofs");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getTypes().contains((Object)DesignType.FLAT_ROOF) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.roof = id++ + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_NORMAL_ROOF);
        button.setToolTip("Gable Roofs");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getTypes().contains((Object)DesignType.ROOF) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.tower = id++ + indexShift;
        button = new IconButton(x += 40, y, ScreenResources.ICON_TOWER_NO_ROOF);
        button.setToolTip("Enable Towers");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getTypes().contains((Object)DesignType.TOWER) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.towerFlatRoof = id++ + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_TOWER_FLAT_ROOF);
        button.setToolTip("Flat Tower Roofs");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getTypes().contains((Object)DesignType.TOWER_FLAT_ROOF) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.towerRoof = id++ + indexShift;
        button = new IconButton(x += 20, y, ScreenResources.ICON_TOWER_ROOF);
        button.setToolTip("Conical Tower Roofs");
        this.toggleButtons.add(button);
        guiIndicator = new Indicator(x, y - 5, "");
        guiIndicator.state = this.theme.getTypes().contains((Object)DesignType.TOWER_ROOF) ? Indicator.State.ON : Indicator.State.OFF;
        this.indicators.add(guiIndicator);
        this.labelRoomHeight = new Label(this.topLeftX + (this.theme.getMaxFloorHeight() > 9 ? 102 : 106), this.topLeftY + 162, "").withShadow();
        this.labelRoomHeight.text = this.theme.getMaxFloorHeight() + "m";
        this.areaRoomHeight = new ScrollInput(this.topLeftX + 100, this.topLeftY + 157, 22, 18).withRange(3, 16).titled("Maximum Height").setState(this.theme.getMaxFloorHeight()).calling(position -> {
            this.labelRoomHeight.text = position + "m";
            this.labelRoomHeight.x = position > 9 ? this.topLeftX + 102 : this.topLeftX + 106;
        });
        this.widgets.add(this.areaRoomHeight);
        this.widgets.add(this.labelRoomHeight);
        this.confirm = new IconButton(this.topLeftX + 172, this.topLeftY + 157, ScreenResources.ICON_CONFIRM);
        this.toggleButtons.add(this.confirm);
        this.widgets.addAll(this.indicators);
        this.widgets.addAll(this.inputs);
        this.widgets.addAll(this.toggleButtons);
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0) {
            for (IconButton button2 : this.toggleButtons) {
                if (!button2.isHovered()) continue;
                this.buttonClicked(button2);
                return true;
            }
        }
        return super.mouseClicked(x, y, button);
    }

    protected void buttonClicked(IconButton button) {
        if (button == this.confirm) {
            this.minecraft.func_147108_a(null);
            return;
        }
        int index = this.toggleButtons.indexOf((Object)button);
        Indicator indicator = this.indicators.get(index);
        if (indicator.state == Indicator.State.YELLOW) {
            return;
        }
        if (indicator.state == Indicator.State.OFF) {
            this.activate(index);
            return;
        }
        if (indicator.state == Indicator.State.ON) {
            this.deactivate(index);
            return;
        }
    }

    private void deactivate(int index) {
        Indicator indicator = this.indicators.get(index);
        indicator.state = Indicator.State.OFF;
        if (index == this.tower) {
            this.deactivate(this.towerFlatRoof);
            this.deactivate(this.towerRoof);
        }
    }

    private void activate(int index) {
        Indicator indicator = this.indicators.get(index);
        indicator.state = Indicator.State.ON;
        if (!(this.activated(this.tower) || index != this.towerFlatRoof && index != this.towerRoof)) {
            this.activate(this.tower);
        }
    }

    private boolean activated(int index) {
        return this.indicators.get((int)index).state != Indicator.State.OFF;
    }

    @Override
    public void renderWindow(int mouseX, int mouseY, float partialTicks) {
        ScreenResources.THEME_EDITOR.draw((AbstractGui)this, this.topLeftX, this.topLeftY);
        int x = this.topLeftX + 10;
        int y = this.topLeftY + 14;
        this.font.func_211126_b("Theme name", (float)x, (float)y, 5726074);
        this.font.func_211126_b("Designer", (float)x, (float)(y + 20), 5726074);
        y = this.topLeftY + 75;
        this.font.func_211126_b("Styles included", (float)x, (float)(y - 17), 5726074);
        this.font.func_211126_b("Shapes and Roof Types included", (float)x, (float)(y + 32), 5726074);
        this.font.func_211126_b("Max. Room Height", (float)x, (float)(y + 87), 5726074);
    }

    public void removed() {
        super.removed();
        if (!this.inputName.func_146179_b().isEmpty()) {
            this.theme.setDisplayName(this.inputName.func_146179_b());
        }
        if (!this.inputAuthor.func_146179_b().isEmpty()) {
            this.theme.setDesigner(this.inputAuthor.func_146179_b());
        }
        this.theme.setMaxFloorHeight(this.areaRoomHeight.getState());
        ArrayList<DesignLayer> layers = new ArrayList<DesignLayer>();
        layers.addAll(DesignLayer.defaults());
        if (this.activated(this.regular)) {
            layers.add(DesignLayer.Regular);
        }
        if (this.activated(this.foundation)) {
            layers.add(DesignLayer.Foundation);
        }
        if (this.activated(this.open)) {
            layers.add(DesignLayer.Open);
        }
        if (this.activated(this.special)) {
            layers.add(DesignLayer.Special);
        }
        if (!this.roofLayerExists()) {
            layers.remove((Object)DesignLayer.Roofing);
        }
        this.theme.setLayers(layers);
        ArrayList<DesignType> types = new ArrayList<DesignType>();
        types.addAll(DesignType.defaults());
        if (this.activated(this.flatRoof)) {
            types.add(DesignType.FLAT_ROOF);
        }
        if (this.activated(this.roof)) {
            types.add(DesignType.ROOF);
        }
        if (this.activated(this.tower)) {
            types.add(DesignType.TOWER);
        }
        if (this.activated(this.towerFlatRoof)) {
            types.add(DesignType.TOWER_FLAT_ROOF);
        }
        if (this.activated(this.towerRoof)) {
            types.add(DesignType.TOWER_ROOF);
        }
        this.theme.setTypes(types);
        ThemeStorage.exportTheme(this.theme);
        ThemeStorage.reloadExternal();
        ArchitectManager.editTheme(this.theme);
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Theme settings have been updated."), true);
    }

    private boolean roofLayerExists() {
        return this.activated(this.roof) || this.activated(this.flatRoof) || this.activated(this.towerFlatRoof) || this.activated(this.towerRoof);
    }
}

