/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.compose.planner.Tools;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ToolSelectionScreen
extends Screen {
    protected List<Tools> tools;
    protected Consumer<Tools> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<Tools> tools, Consumer<Tools> callback) {
        super((ITextComponent)new StringTextComponent("Tool Selection"));
        this.minecraft = Minecraft.func_71410_x();
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.w = tools.size() * 50 + 30;
        this.h = 30;
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(float partialTicks) {
        MainWindow mainWindow = Minecraft.func_71410_x().field_195558_d;
        FontRenderer font = this.minecraft.field_71466_p;
        int x = (mainWindow.func_198107_o() - this.w) / 2 + 15;
        int y = 15;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(this.focused ? 100.0f : 0.0f));
        ScreenResources gray = ScreenResources.GRAY;
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.focused ? 0.875f : 0.5f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        float toolTipAlpha = this.yOffset / 10.0f;
        ToolSelectionScreen.blit((int)(x - 15), (int)y, (float)gray.startX, (float)gray.startY, (int)this.w, (int)this.h, (int)gray.width, (int)gray.height);
        List<String> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
            GlStateManager.color4f((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            ToolSelectionScreen.blit((int)(x - 15), (int)(y + 30), (float)gray.startX, (float)gray.startY, (int)this.w, (int)(this.h + 22), (int)gray.width, (int)gray.height);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                this.drawString(font, toolTip.get(0), x - 10, y + 35, 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                this.drawString(font, toolTip.get(1), x - 10, y + 47, 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                this.drawString(font, toolTip.get(2), x - 10, y + 57, 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                this.drawString(font, toolTip.get(3), x - 10, y + 69, 0xCCCCDD + stringAlphaComponent);
            }
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String translationKey = TheMightyArchitect.TOOL_MENU.func_197978_k().toUpperCase();
        int width = this.minecraft.field_195558_d.func_198107_o();
        if (!this.focused) {
            this.drawCenteredString(this.minecraft.field_71466_p, "Hold [" + translationKey + "] to focus", width / 2, y - 10, 0xCCDDFF);
        } else {
            this.drawCenteredString(this.minecraft.field_71466_p, "[SCROLL] to Cycle", width / 2, y - 10, 0xCCDDFF);
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            GlStateManager.pushMatrix();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                GlStateManager.translatef((float)0.0f, (float)-10.0f, (float)0.0f);
                this.drawCenteredString(this.minecraft.field_71466_p, this.tools.get(i).getDisplayName(), x + i * 50 + 24, y + 28, 0xCCDDFF);
                alpha = 1.0f;
            }
            GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().draw((AbstractGui)this, x + i * 50 + 16, y + 12);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().draw((AbstractGui)this, x + i * 50 + 16, y + 11);
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(float partialTicks) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        this.draw(partialTicks);
    }

    public void onClose() {
        this.callback.accept(this.tools.get(this.selection));
    }
}

