/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.item;

import com.simibubi.mightyarchitect.AllBlocks;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.phase.ArchitectPhases;
import com.simibubi.mightyarchitect.control.phase.export.PhaseEditTheme;
import com.simibubi.mightyarchitect.gui.DesignExporterScreen;
import com.simibubi.mightyarchitect.gui.ScreenHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ArchitectWandItem
extends Item {
    public ArchitectWandItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.RARE));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_70093_af()) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGui());
            return ActionResultType.SUCCESS;
        }
        BlockPos anchor = context.func_195995_a();
        BlockState blockState = world.func_180495_p(anchor);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.handleUseOnDesignAnchor(player, world, anchor, blockState));
        player.func_184811_cZ().func_185145_a((Item)this, 5);
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void resetVisualization() {
        PhaseEditTheme.resetVisualization();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void handleUseOnDesignAnchor(PlayerEntity player, World world, BlockPos anchor, BlockState blockState) {
        if (AllBlocks.DESIGN_ANCHOR.typeOf(blockState)) {
            if (!ArchitectManager.inPhase(ArchitectPhases.EditingThemes)) {
                return;
            }
            String name = DesignExporter.exportDesign(world, anchor);
            if (!name.isEmpty()) {
                player.func_146105_b((ITextComponent)new StringTextComponent(name), true);
            }
        } else {
            if (!ArchitectManager.inPhase(ArchitectPhases.EditingThemes)) {
                return;
            }
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::resetVisualization);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.handleRightClick(worldIn, playerIn, handIn));
            playerIn.func_184811_cZ().func_185145_a((Item)this, 5);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void handleRightClick(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!ArchitectManager.inPhase(ArchitectPhases.EditingThemes)) {
            return;
        }
        if (playerIn.func_70093_af()) {
            this.openGui();
        } else {
            this.resetVisualization();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGui() {
        if (!ArchitectManager.inPhase(ArchitectPhases.EditingThemes)) {
            return;
        }
        ScreenHelper.open(new DesignExporterScreen());
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }
}

