/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.AllItems;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.SchematicRenderer;
import com.simibubi.mightyarchitect.foundation.utility.AnimationTickHolder;
import com.simibubi.mightyarchitect.foundation.utility.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MightyClient {
    public static KeyBinding COMPOSE;
    public static KeyBinding TOOL_MENU;
    public static SchematicRenderer renderer;
    public static Outliner outliner;

    public static void init() {
        AllItems.initColorHandlers();
        String modName = "The Mighty Architect";
        COMPOSE = new KeyBinding("Start composing", 71, modName);
        TOOL_MENU = new KeyBinding("Tool Menu (Hold)", 342, modName);
        ClientRegistry.registerKeyBinding((KeyBinding)COMPOSE);
        ClientRegistry.registerKeyBinding((KeyBinding)TOOL_MENU);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        AnimationTickHolder.tick();
        if (!MightyClient.isGameActive()) {
            return;
        }
        ArchitectManager.tickBlockHighlightOutlines();
        outliner.tickOutlines();
        renderer.tick();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        MatrixStack ms = event.getMatrixStack();
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d view = info.func_216785_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        ArchitectManager.render(ms, (IRenderTypeBuffer)buffer);
        renderer.render(ms, (IRenderTypeBuffer)buffer);
        outliner.renderOutlines(ms, (IRenderTypeBuffer)buffer);
        buffer.func_228461_a_();
        ms.func_227865_b_();
    }

    protected static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }

    static {
        renderer = new SchematicRenderer();
        outliner = new Outliner();
    }
}

