/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose;

import com.simibubi.mightyarchitect.AllSpecialTextures;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

public class Stack {
    protected List<Room> rooms = new ArrayList<Room>();
    protected DesignTheme theme;

    public Stack(Room room) {
        this.theme = ArchitectManager.getModel().getGroundPlan().theme;
        if (room.designLayer == DesignLayer.None) {
            room.designLayer = this.theme.getLayers().contains((Object)DesignLayer.Foundation) ? DesignLayer.Foundation : DesignLayer.Regular;
        }
        this.rooms.add(room);
    }

    public Room lowest() {
        if (this.rooms.isEmpty()) {
            return null;
        }
        return this.rooms.get(0);
    }

    public Room highest() {
        if (this.rooms.isEmpty()) {
            return null;
        }
        return this.rooms.get(this.rooms.size() - 1);
    }

    public void increase() {
        this.insertNewAt(this.rooms.size(), false);
    }

    @Nullable
    public Room insertNewAt(int index, boolean exactCopy) {
        if (this.rooms.size() >= 25) {
            return null;
        }
        Room reference = this.rooms.get(Math.max(0, index - 1));
        Room newRoom = reference.stack(exactCopy);
        if (reference.designLayer == DesignLayer.Foundation) {
            newRoom.designLayer = DesignLayer.Regular;
        }
        if (!exactCopy) {
            int defaultHeightForFloor = this.theme.getDefaultHeightForFloor(this.rooms.size());
            newRoom.height = defaultHeightForFloor != -1 ? defaultHeightForFloor : Math.max(reference.height, Math.min(4, this.theme.getMaxFloorHeight()));
        }
        this.rooms.add(index, newRoom);
        this.forEachAbove(newRoom, r -> r.move(0, newRoom.height, 0));
        return newRoom;
    }

    public void removeRoom(Room room) {
        if (room == this.highest()) {
            this.decrease();
            return;
        }
        this.forEachAbove(room, r -> r.move(0, -room.height, 0));
        this.rooms.remove(room);
    }

    public void decrease() {
        if (!this.rooms.isEmpty()) {
            if (this.rooms.size() > 1) {
                this.rooms.get((int)(this.rooms.size() - 2)).roofType = this.highest().roofType;
                this.rooms.get((int)(this.rooms.size() - 2)).quadFacadeRoof = this.highest().quadFacadeRoof;
            }
            this.rooms.remove(this.highest());
        }
    }

    public void forEachAbove(Room anchor, Consumer<? super Room> action) {
        this.rooms.subList(this.rooms.indexOf(anchor) + 1, this.rooms.size()).forEach(action);
    }

    public void forRoomAndEachAbove(Room anchor, Consumer<? super Room> action) {
        this.rooms.subList(this.rooms.indexOf(anchor), this.rooms.size()).forEach(action);
    }

    public void forEach(Consumer<? super Room> action) {
        this.rooms.forEach(action);
    }

    public Room getRoomAtPos(BlockPos localPos) {
        for (Room room : this.rooms) {
            if (!room.contains(localPos)) continue;
            return room;
        }
        return null;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public int floors() {
        return this.rooms.size();
    }

    public int getMaxFacadeWidth() {
        return 35;
    }

    public int getMinWidth() {
        return this.theme.getStatistics().MinRoomLength;
    }

    public DesignType getRoofType() {
        return this.highest().roofType;
    }

    public AllSpecialTextures getTextureOf(Room room) {
        switch (room.designLayer) {
            case Foundation: {
                return AllSpecialTextures.FOUNDATION;
            }
        }
        return AllSpecialTextures.NORMAL;
    }
}

