/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.AllSpecialTextures;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.ComposerToolBase;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.foundation.utility.RaycastHelper;
import com.simibubi.mightyarchitect.foundation.utility.outliner.Outline;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public abstract class GroundPlanningToolBase
extends ComposerToolBase {
    protected BlockPos selectedPosition;
    protected Set<Stack> transparentStacks;
    private Vec3d prevVertex;
    private int vertexCounter;
    private String key;

    @Override
    public void init() {
        super.init();
        this.selectedPosition = null;
        this.transparentStacks = new HashSet<Stack>();
    }

    @Override
    public void updateSelection() {
        super.updateSelection();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.transparentStacks.clear();
        BlockRayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (PlayerEntity)player, 75.0);
        if (trace != null && trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos hit = new BlockPos(trace.func_216347_e());
            this.makeStacksTransparent(player, hit);
            boolean replaceable = player.field_70170_p.func_180495_p(hit).func_196953_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, trace)));
            if (trace.func_216354_b().func_176740_k().func_200128_b() && !replaceable) {
                hit = hit.func_177972_a(trace.func_216354_b());
            }
            this.selectedPosition = this.model.getAnchor() == null ? hit : hit.func_177973_b((Vec3i)this.model.getAnchor());
        } else {
            this.selectedPosition = null;
        }
    }

    protected void makeStacksTransparent(ClientPlayerEntity player, BlockPos hit) {
        if (!this.model.getGroundPlan().isEmpty()) {
            BlockPos target = hit;
            RaycastHelper.rayTraceUntil((PlayerEntity)player, 75.0, pos -> {
                BlockPos localPos = pos.func_177973_b((Vec3i)this.model.getAnchor());
                this.model.getGroundPlan().forEachStack(stack -> {
                    if (stack.getRoomAtPos(localPos) != null) {
                        this.transparentStacks.add((Stack)stack);
                    }
                });
                return pos.equals((Object)target);
            });
        }
    }

    @Override
    public String handleRightClick() {
        if (this.selectedPosition == null) {
            return null;
        }
        if (this.model.getAnchor() == null) {
            this.model.setAnchor(this.selectedPosition);
            this.selectedPosition = BlockPos.field_177992_a;
        }
        return null;
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        return false;
    }

    @Override
    public void tickGroundPlanOutlines() {
        GroundPlan groundPlan = this.model.getGroundPlan();
        BlockPos anchor = this.model.getAnchor();
        if (groundPlan == null || anchor == null) {
            return;
        }
        groundPlan.forEachStack(stack -> {
            boolean stackTransparent = this.transparentStacks.contains(stack);
            boolean stackHighlighted = this.isStackHighlighted((Stack)stack);
            stack.forEach(room -> {
                boolean roomHighlighted = this.isRoomHighlighted((Room)room);
                MightyClient.outliner.chaseAABB(room, room.toAABB().func_186670_a(anchor)).withFaceTexture(roomHighlighted ? AllSpecialTextures.SuperSelectedRoom : (stackTransparent ? AllSpecialTextures.SelectedRoom : (stackHighlighted ? AllSpecialTextures.SelectedRoom : stack.getTextureOf((Room)room)))).colored(0x111111).coloredFaces(0x555555).lineWidth(0.125f).fadesAfter(2).hideBottom(room != stack.lowest() && !roomHighlighted).hideTop((room != stack.highest() || room.roofType == DesignType.NONE) && !roomHighlighted);
            });
        });
        this.tickRoofOutlines();
    }

    protected boolean isStackHighlighted(Stack stack) {
        return false;
    }

    protected boolean isRoomHighlighted(Room room) {
        return false;
    }

    protected void tickRoofOutlines() {
        GroundPlan groundPlan = this.model.getGroundPlan();
        BlockPos anchor = this.model.getAnchor();
        groundPlan.forEachStack(stack -> {
            Room room = stack.highest();
            float x = room.x + anchor.func_177958_n();
            float y = room.y + anchor.func_177956_o();
            float z = room.z + anchor.func_177952_p();
            float h = room.height;
            float l = room.length;
            float w = room.width;
            DesignType roofType = room.roofType;
            if (stack instanceof CylinderStack && roofType == DesignType.ROOF) {
                roofType = DesignType.TOWER_ROOF;
            }
            ArrayList<Outline.OutlineParams> lines = new ArrayList<Outline.OutlineParams>();
            String string = stack.toString();
            boolean alongZ = w >= l;
            switch (roofType) {
                case TOWER_ROOF: {
                    this.key(string + "A").vertex(x, y + h, z, lines).vertex(x + w / 2.0f, y + h + w, z + l / 2.0f, lines).vertex(x, y + h, z + l, lines).end();
                    this.key(string + "B").vertex(x + w, y + h, z + l, lines).vertex(x + w / 2.0f, y + h + w, z + l / 2.0f, lines).vertex(x + w, y + h, z, lines).end();
                    this.key(string).vertex(x, y + h, z, lines).vertex(x, y + h, z + l, lines).vertex(x + w, y + h, z + l, lines).vertex(x + w, y + h, z, lines).vertex(x, y + h, z, lines).end();
                    break;
                }
                case FLAT_ROOF: 
                case TOWER_FLAT_ROOF: {
                    y = (float)((double)y + 0.25);
                    this.key(string).vertex(x, y + h, z, lines).vertex(x, y + h, z + l, lines).vertex(x + w, y + h, z + l, lines).vertex(x + w, y + h, z, lines).vertex(x, y + h, z, lines).end();
                    y = (float)((double)y + 0.5);
                    this.key(string + "A").vertex(x, y + h, z, lines).vertex(x, y + h, z + l, lines).vertex(x + w, y + h, z + l, lines).vertex(x + w, y + h, z, lines).vertex(x, y + h, z, lines).end();
                    break;
                }
                case ROOF: {
                    boolean q = room.quadFacadeRoof;
                    this.key(string).vertex(x, y + h, z, lines);
                    if (alongZ || q) {
                        this.vertex(x, y + h + l / 2.0f, z + l / 2.0f, lines);
                    }
                    this.vertex(x, y + h, z + l, lines);
                    if (!alongZ || q) {
                        this.vertex(x + w / 2.0f, y + h + w / 2.0f, z + l, lines);
                    }
                    this.vertex(x + w, y + h, z + l, lines);
                    if (alongZ || q) {
                        this.vertex(x + w, y + h + l / 2.0f, z + l / 2.0f, lines);
                    }
                    this.vertex(x + w, y + h, z, lines);
                    if (!alongZ || q) {
                        this.vertex(x + w / 2.0f, y + h + w / 2.0f, z, lines);
                    }
                    this.vertex(x, y + h, z, lines).end();
                    if (!alongZ || q) {
                        this.key(string + "A").vertex(x + w / 2.0f, y + h + w / 2.0f, z + l, lines).vertex(x + w / 2.0f, y + h + w / 2.0f, z, lines).end();
                    }
                    if (!alongZ && !q) break;
                    this.key(string + "B").vertex(x, y + h + l / 2.0f, z + l / 2.0f, lines).vertex(x + w, y + h + l / 2.0f, z + l / 2.0f, lines).end();
                    break;
                }
            }
            lines.forEach(op -> op.lineWidth(0.25f).colored(0x222222));
        });
    }

    GroundPlanningToolBase key(String key) {
        this.key = key;
        return this;
    }

    GroundPlanningToolBase vertex(double x, double y, double z, List<Outline.OutlineParams> lines) {
        Vec3d previousVec = this.prevVertex;
        this.prevVertex = new Vec3d(x, y, z);
        if (previousVec == null) {
            return this;
        }
        lines.add(MightyClient.outliner.chaseLine(this.key + this.vertexCounter, previousVec, this.prevVertex));
        ++this.vertexCounter;
        return this;
    }

    void end() {
        this.key = null;
        this.prevVertex = null;
        this.vertexCounter = 0;
    }
}

