/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.planner.AbstractRoomFaceSelectionTool;
import com.simibubi.mightyarchitect.control.design.ThemeStatistics;
import com.simibubi.mightyarchitect.foundation.utility.Keyboard;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class MoveReshapeTool
extends AbstractRoomFaceSelectionTool {
    @Override
    public void init() {
        super.init();
        this.toolModeNoCtrl = "Move (XZ)";
        this.toolModeCtrl = "Resize (XZ)";
    }

    @Override
    protected boolean isRoomHighlighted(Room room) {
        boolean isSelected = super.isRoomHighlighted(room);
        if (isSelected) {
            return true;
        }
        if (selectedStack == null || selectedRoom == null) {
            return false;
        }
        List<Room> rooms = selectedStack.getRooms();
        if (!rooms.contains(selectedRoom) || !rooms.contains(room)) {
            return false;
        }
        return rooms.indexOf(selectedRoom) <= rooms.indexOf(room);
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        if (selectedRoom != null) {
            if (Keyboard.isKeyDown(341)) {
                ThemeStatistics statistics = this.model.getTheme().getStatistics();
                selectedStack.forRoomAndEachAbove(selectedRoom, room -> {
                    int newLength;
                    BlockPos diff = BlockPos.field_177992_a.func_177967_a(selectedFace, scroll);
                    if (selectedStack instanceof CylinderStack) {
                        if (scroll < 0 && room.width < statistics.MaxTowerRadius * 2 + 1) {
                            --room.x;
                            --room.z;
                            room.width += 2;
                            room.length += 2;
                        }
                        if (scroll > 0 && room.width > statistics.MinTowerRadius * 2 + 1) {
                            ++room.x;
                            ++room.z;
                            room.width -= 2;
                            room.length -= 2;
                        }
                        return;
                    }
                    int faceDirection = selectedFace.func_176743_c().func_179524_a();
                    int newWidth = room.width - 2 * diff.func_177958_n() * faceDirection;
                    if (Math.min(newWidth, newLength = room.length - 2 * diff.func_177952_p() * faceDirection) < statistics.MinRoomLength) {
                        return;
                    }
                    if (Math.max(newWidth, newLength) > statistics.MaxRoomLength) {
                        return;
                    }
                    room.x += diff.func_177958_n() * faceDirection;
                    room.width = newWidth;
                    room.z += diff.func_177952_p() * faceDirection;
                    room.length = newLength;
                });
                MoveReshapeTool.selectedStack.highest().roofType = statistics.fallbackRoof(selectedStack.highest(), selectedStack instanceof CylinderStack);
                this.status("Size: " + TextFormatting.AQUA + MoveReshapeTool.selectedRoom.width + TextFormatting.WHITE + "x" + TextFormatting.AQUA + MoveReshapeTool.selectedRoom.length);
            } else {
                selectedStack.forRoomAndEachAbove(selectedRoom, room -> {
                    BlockPos diff = BlockPos.field_177992_a.func_177967_a(selectedFace, scroll);
                    room.move(-diff.func_177958_n(), 0, -diff.func_177952_p());
                });
                this.status("Position: " + TextFormatting.AQUA + MoveReshapeTool.selectedRoom.x + TextFormatting.WHITE + ", " + TextFormatting.AQUA + MoveReshapeTool.selectedRoom.z);
            }
            return true;
        }
        return super.handleMouseWheel(scroll);
    }
}

