/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.AllBlocks;
import com.simibubi.mightyarchitect.AllPackets;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.block.SliceMarkerBlock;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignSlice;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.partials.Wall;
import com.simibubi.mightyarchitect.control.palette.BlockOrientation;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.phase.export.PhaseEditTheme;
import com.simibubi.mightyarchitect.foundation.utility.FilesHelper;
import com.simibubi.mightyarchitect.networking.PlaceSignPacket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class DesignExporter {
    public static PaletteDefinition scanningPalette = PaletteDefinition.defaultPalette();
    public static DesignTheme theme;
    public static DesignType type;
    public static DesignLayer layer;
    public static int designParameter;
    public static boolean changed;

    public static String exportDesign(World worldIn, BlockPos anchor) {
        BlockPos layerDefAnchor = anchor;
        boolean found = false;
        block6: for (int range = 1; range < 100 && !found; ++range) {
            for (int i = 0; i <= range; ++i) {
                if (DesignExporter.isMarker(worldIn, anchor.func_177982_a(range, 0, i))) {
                    layerDefAnchor = anchor.func_177982_a(range, 0, i);
                    found = true;
                    continue block6;
                }
                if (!DesignExporter.isMarker(worldIn, anchor.func_177982_a(i, 0, range))) continue;
                layerDefAnchor = anchor.func_177982_a(i, 0, range);
                found = true;
                continue block6;
            }
        }
        if (!found) {
            return "";
        }
        int height = 0;
        int effectiveHeight = 0;
        BlockPos pos = layerDefAnchor;
        while (DesignExporter.isMarker(worldIn, pos)) {
            ++height;
            if (DesignSlice.DesignSliceTrait.values()[DesignExporter.markerValueAt(worldIn, pos)] != DesignSlice.DesignSliceTrait.MaskAbove) {
                ++effectiveHeight;
            }
            pos = pos.func_177984_a();
        }
        if (effectiveHeight != PhaseEditTheme.effectiveHeight) {
            PhaseEditTheme.effectiveHeight = effectiveHeight;
            changed = true;
        }
        BlockPos size = layerDefAnchor.func_177976_e().func_177973_b((Vec3i)anchor.func_177974_f()).func_177982_a(1, height, 1);
        boolean visualizing = PhaseEditTheme.isVisualizing();
        Cuboid bounds = new Cuboid(anchor.func_177974_f(), size);
        boolean boundsChanged = visualizing && !PhaseEditTheme.selectedDesign.equals(bounds) || changed;
        changed = false;
        if (!visualizing || boundsChanged) {
            PhaseEditTheme.setVisualization(bounds);
            return "Design traits visualized, click again to confirm.";
        }
        PhaseEditTheme.resetVisualization();
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Size", (INBT)NBTUtil.func_186859_a((BlockPos)size));
        ListNBT layers = new ListNBT();
        for (int y = 0; y < size.func_177956_o(); ++y) {
            CompoundNBT layerTag = new CompoundNBT();
            DesignSlice.DesignSliceTrait trait = DesignSlice.DesignSliceTrait.values()[DesignExporter.markerValueAt(worldIn, layerDefAnchor.func_177981_b(y))];
            layerTag.func_74778_a("Trait", trait.name());
            StringBuilder data = new StringBuilder();
            for (int z = 0; z < size.func_177952_p(); ++z) {
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    BlockPos pos2 = anchor.func_177974_f().func_177982_a(x, y, z);
                    BlockState blockState = worldIn.func_180495_p(pos2);
                    Palette block = scanningPalette.scan(blockState);
                    if (block == null && blockState.func_177230_c() != Blocks.field_150350_a) {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(blockState.func_177230_c().func_149739_a() + " @" + pos2.func_177958_n() + "," + pos2.func_177956_o() + "," + pos2.func_177952_p() + " does not belong to the Scanner Palette"));
                        return "Export failed";
                    }
                    data.append(block != null ? (char)block.asChar() : (char)' ');
                }
                if (z >= size.func_177952_p() - 1) continue;
                data.append(",");
            }
            layerTag.func_74778_a("Blocks", data.toString());
            StringBuilder orientationStrip = new StringBuilder();
            for (int z = 0; z < size.func_177952_p(); ++z) {
                for (int x = 0; x < size.func_177958_n(); ++x) {
                    BlockOrientation orientation = BlockOrientation.byState(worldIn.func_180495_p(anchor.func_177974_f().func_177982_a(x, y, z)));
                    orientationStrip.append(orientation.asChar());
                }
                if (z >= size.func_177952_p() - 1) continue;
                orientationStrip.append(",");
            }
            layerTag.func_74778_a("Facing", orientationStrip.toString());
            layers.add((Object)layerTag);
        }
        compound.func_218657_a("Layers", (INBT)layers);
        int data = designParameter;
        switch (type) {
            case ROOF: {
                compound.func_74768_a("Roofspan", data);
                break;
            }
            case FLAT_ROOF: {
                compound.func_74768_a("Margin", data);
                break;
            }
            case WALL: {
                if (data == -1) {
                    return "Revisit the Design settings.";
                }
                Wall.ExpandBehaviour expandBehaviour = Wall.ExpandBehaviour.values()[data];
                if (size.func_177958_n() == 1 && expandBehaviour == Wall.ExpandBehaviour.MergedRepeat) {
                    return "Can't merge Walls of length 1. Use 'Repeat' instead.";
                }
                compound.func_74778_a("ExpandBehaviour", expandBehaviour.name());
                break;
            }
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: 
            case TOWER: {
                compound.func_74768_a("Radius", data);
                break;
            }
        }
        String basePath = "themes";
        FilesHelper.createFolderIfMissing(basePath);
        String themePath = basePath + "/" + theme.getFilePath();
        FilesHelper.createFolderIfMissing(themePath);
        String layerPath = themePath + "/" + layer.getFilePath();
        FilesHelper.createFolderIfMissing(layerPath);
        String typePath = layerPath + "/" + type.getFilePath();
        FilesHelper.createFolderIfMissing(typePath);
        String filename = "";
        String designPath = "";
        BlockPos signPos = anchor.func_177984_a();
        if (worldIn.func_180495_p(signPos).func_177230_c() == Blocks.field_222385_bY) {
            SignTileEntity sign = (SignTileEntity)worldIn.func_175625_s(signPos);
            filename = sign.field_145915_a[1].getString();
            designPath = typePath + "/" + filename;
        } else {
            for (int index = 0; index < 2048; ++index) {
                filename = "design" + (index == 0 ? "" : "_" + index) + ".json";
                designPath = typePath + "/" + filename;
                if (TheMightyArchitect.class.getClassLoader().getResource(designPath) == null && !Files.exists(Paths.get(designPath, new String[0]), new LinkOption[0])) break;
            }
        }
        AllPackets.channel.sendToServer((Object)new PlaceSignPacket(layer.getDisplayName().substring(0, 1) + ". " + type.getDisplayName(), filename, signPos));
        FilesHelper.saveTagCompoundAsJson(compound, designPath);
        return designPath;
    }

    public static void setTheme(DesignTheme theme) {
        DesignExporter.theme = theme;
        scanningPalette = theme.getDefaultPalette();
        if (layer == null || !theme.getLayers().contains((Object)layer)) {
            layer = DesignLayer.Regular;
        }
        if (type == null || !theme.getTypes().contains((Object)type)) {
            type = DesignType.WALL;
        }
        changed = true;
    }

    public static DesignTheme getTheme() {
        return theme;
    }

    private static boolean isMarker(World worldIn, BlockPos pos) {
        return AllBlocks.SLICE_MARKER.typeOf(worldIn.func_180495_p(pos));
    }

    private static int markerValueAt(World worldIn, BlockPos pos) {
        return ((DesignSlice.DesignSliceTrait)((Object)worldIn.func_180495_p(pos).func_177229_b(SliceMarkerBlock.VARIANT))).ordinal();
    }

    static {
        changed = true;
    }
}

