/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.Sketch;
import com.simibubi.mightyarchitect.control.design.TemporaryDesignCache;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.foundation.utility.DesignHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DesignPicker {
    private DesignTheme theme;
    private Map<Room, RoomDesignMapping> roomDesigns = new HashMap<Room, RoomDesignMapping>();
    private Map<Stack, Design> roofDesigns = new HashMap<Stack, Design>();

    public void reset() {
        this.rerollAll();
    }

    public Sketch assembleSketch(GroundPlan groundPlan, int seed) {
        Sketch sketch = this.pickDesigns(groundPlan, seed);
        return sketch;
    }

    private Sketch pickDesigns(GroundPlan groundPlan, int seed) {
        Sketch sketch = new Sketch();
        TemporaryDesignCache provider = new TemporaryDesignCache(this.roomDesigns, this.roofDesigns, seed);
        groundPlan.forEachStack(stack -> stack.forEach(room -> {
            List<Design.DesignInstance> designList;
            List<Design.DesignInstance> list = designList = room.secondaryPalette ? sketch.secondary : sketch.primary;
            if (stack instanceof CylinderStack) {
                DesignHelper.addTower(provider, designList, this.theme, room.designLayer, room);
            } else {
                DesignHelper.addCuboid(provider, designList, this.theme, room.designLayer, room);
            }
            if (room != stack.highest()) {
                return;
            }
            DesignLayer roofLayer = DesignLayer.Roofing;
            switch (room.roofType) {
                case ROOF: {
                    if (stack instanceof CylinderStack) {
                        DesignHelper.addTowerRoof(provider, designList, this.theme, roofLayer, stack, false);
                        break;
                    }
                    if (room.quadFacadeRoof) {
                        DesignHelper.addNormalCrossRoof(provider, designList, this.theme, roofLayer, stack);
                        break;
                    }
                    DesignHelper.addNormalRoof(provider, designList, this.theme, roofLayer, stack);
                    break;
                }
                case FLAT_ROOF: {
                    if (stack instanceof CylinderStack) {
                        DesignHelper.addTowerRoof(provider, designList, this.theme, roofLayer, stack, true);
                        break;
                    }
                    DesignHelper.addFlatRoof(provider, designList, this.theme, roofLayer, stack);
                    break;
                }
            }
        }));
        sketch.interior = groundPlan.getInterior();
        return sketch;
    }

    public RoomDesignMapping getCachedRoom(Room room) {
        if (this.roomDesigns.containsKey(room)) {
            return this.roomDesigns.get(room);
        }
        return null;
    }

    public Design getCachedRoof(Stack stack) {
        if (this.roofDesigns.containsKey(stack)) {
            return this.roofDesigns.get(stack);
        }
        return null;
    }

    public void rerollAll() {
        this.roomDesigns.clear();
        this.roofDesigns.clear();
    }

    public void rerollRoom(Room room) {
        if (this.roomDesigns.containsKey(room)) {
            this.roomDesigns.remove(room);
        }
    }

    public void rerollRoof(Stack stack) {
        if (this.roofDesigns.containsKey(stack)) {
            this.roofDesigns.remove(stack);
        }
    }

    public void rerollStack(Stack stack) {
        stack.forEach(this::rerollRoom);
        this.rerollRoof(stack);
    }

    public void putRoom(Room room, RoomDesignMapping mapping) {
        this.roomDesigns.put(room, mapping);
    }

    public void putRoof(Stack stack, Design roof) {
        this.roofDesigns.put(stack, roof);
    }

    public void setTheme(DesignTheme theme) {
        this.theme = theme;
    }

    public static class RoomDesignMapping {
        public Design wall1;
        public Design wall2;
        public Design corner;

        public RoomDesignMapping(Design tower) {
            this.wall1 = tower;
        }

        public RoomDesignMapping(Design wall1, Design wall2, Design corner) {
            this.wall1 = wall1;
            this.wall2 = wall2;
            this.corner = corner;
        }
    }
}

