/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.foundation.utility.DesignHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ThemeStatistics {
    public static final int MIN_TOWER_RADIUS = 1;
    public static final int MAX_TOWER_RADIUS = 15;
    public static final int MIN_ROOF_SPAN = 3;
    public static final int MAX_ROOF_SPAN = 35;
    public static final int MIN_MARGIN = 0;
    public static final int MAX_MARGIN = 15;
    public static final int MAX_FLOORS = 25;
    public int MinRoomLength = 3;
    public int MaxRoomLength = 97;
    public int MinFlatRoof = 3;
    public int MinGableRoof = 3;
    public int MaxGableRoof = 15;
    public boolean hasGables = true;
    public boolean hasFlatRoof = true;
    public int MinTowerRadius = 1;
    public int MaxConicalRoofRadius = 5;
    public int MaxTowerRadius = 5;
    public boolean hasTowers = true;
    public boolean hasFlatTowerRoof = true;
    public boolean hasConicalRoof = true;

    public static ThemeStatistics evaluate(DesignTheme theme) {
        DesignQuery roofQuery;
        ThemeStatistics stats = new ThemeStatistics();
        if (!theme.getTypes().contains((Object)DesignType.TOWER_FLAT_ROOF)) {
            stats.hasFlatTowerRoof = false;
        }
        if (!theme.getTypes().contains((Object)DesignType.TOWER_ROOF)) {
            stats.hasConicalRoof = false;
        }
        if (theme.getTypes().contains((Object)DesignType.TOWER)) {
            stats.MinTowerRadius = stats.MaxRoomLength;
            stats.MaxTowerRadius = 0;
            stats.MaxConicalRoofRadius = 0;
            stats.hasTowers = false;
            block0: for (DesignLayer layer : theme.getRoomLayers()) {
                DesignQuery towerQuery = new DesignQuery(theme, layer, DesignType.TOWER);
                DesignQuery conicalRoofQuery = new DesignQuery(theme, DesignLayer.Roofing, DesignType.TOWER_ROOF);
                if (ThemeStatistics.designExists(towerQuery)) {
                    int radius;
                    stats.hasTowers = true;
                    for (radius = 1; radius <= stats.MaxRoomLength; ++radius) {
                        if (!ThemeStatistics.designExists(towerQuery.withWidth(radius * 2 + 1))) continue;
                        stats.MinTowerRadius = Math.min(radius, stats.MinTowerRadius);
                        break;
                    }
                    for (radius = stats.MaxRoomLength; radius >= stats.MinTowerRadius; --radius) {
                        if (!ThemeStatistics.designExists(towerQuery.withWidth(radius * 2 + 1))) continue;
                        stats.MaxTowerRadius = Math.max(radius, stats.MaxTowerRadius);
                        break;
                    }
                    for (radius = stats.MaxTowerRadius; radius >= stats.MinTowerRadius; --radius) {
                        if (!ThemeStatistics.designExists(conicalRoofQuery.withWidth(radius * 2 + 1))) continue;
                        stats.MaxConicalRoofRadius = Math.max(radius, stats.MaxConicalRoofRadius);
                        continue block0;
                    }
                    continue;
                }
                break;
            }
        } else {
            stats.hasTowers = false;
        }
        if (theme.getTypes().contains((Object)DesignType.ROOF)) {
            int roofSpan;
            roofQuery = new DesignQuery(theme, DesignLayer.Roofing, DesignType.ROOF);
            if (!ThemeStatistics.designExists(roofQuery)) {
                stats.hasGables = false;
            }
            for (roofSpan = 3; roofSpan <= 15; roofSpan += 2) {
                if (!ThemeStatistics.designExists(roofQuery.withWidth(roofSpan))) continue;
                stats.MinGableRoof = roofSpan;
                break;
            }
            for (roofSpan = stats.MaxRoomLength; roofSpan >= stats.MinGableRoof; roofSpan -= 2) {
                if (!ThemeStatistics.designExists(roofQuery.withWidth(roofSpan))) continue;
                stats.MaxGableRoof = roofSpan;
                break;
            }
        } else {
            stats.hasGables = false;
            stats.MinGableRoof = stats.MaxRoomLength;
        }
        if (theme.getTypes().contains((Object)DesignType.FLAT_ROOF)) {
            roofQuery = new DesignQuery(theme, DesignLayer.Roofing, DesignType.FLAT_ROOF);
            if (!ThemeStatistics.designExists(roofQuery)) {
                stats.hasFlatRoof = false;
            }
            for (int roofSpan = 3; roofSpan <= stats.MaxRoomLength; roofSpan += 2) {
                if (!ThemeStatistics.designExists(roofQuery.withWidth(roofSpan))) continue;
                stats.MinFlatRoof = roofSpan;
                break;
            }
        } else {
            stats.hasFlatRoof = false;
            stats.MinFlatRoof = stats.MaxRoomLength;
        }
        if (stats.hasFlatRoof || stats.hasGables) {
            stats.MinRoomLength = Math.min(stats.MinGableRoof, stats.MinFlatRoof);
        }
        return stats;
    }

    protected static boolean designExists(DesignQuery query) {
        return DesignHelper.pickRandom(query.withoutFallback(), new Random()) != null;
    }

    public void sendToPlayer() {
        this.chat("Room size: " + this.MinRoomLength + " to " + (this.MaxRoomLength == 97 ? "Infinity" : Integer.valueOf(this.MaxRoomLength)));
        if (this.hasFlatRoof) {
            this.chat("Smallest Flat Roof Spans: " + this.MinFlatRoof);
        } else {
            this.chat("No Flat Roofing");
        }
        if (this.hasGables) {
            this.chat("Gable Roofs span: " + this.MinGableRoof + " to " + this.MaxGableRoof);
        } else {
            this.chat("No Gable Roofing");
        }
        if (this.hasTowers) {
            this.chat("Tower radii: " + this.MinTowerRadius + " to " + this.MaxTowerRadius);
            if (this.hasFlatTowerRoof) {
                this.chat("Has Flat Tower Roofing");
            } else {
                this.chat("No Flat Tower Roofing");
            }
            if (this.hasConicalRoof) {
                this.chat("Largest Conical Roof radius: " + this.MaxConicalRoofRadius);
            } else {
                this.chat("No Conical Roofing");
            }
        } else {
            this.chat("No Towers");
        }
    }

    private void chat(String message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(message));
    }

    public DesignType fallbackRoof(Room room, boolean tower) {
        DesignType desired = room.roofType;
        if (!tower && room.quadFacadeRoof && room.width != room.length) {
            room.quadFacadeRoof = false;
        }
        if (!tower && desired == DesignType.ROOF) {
            if (this.hasGables && Math.min(room.width, room.length) <= this.MaxGableRoof && Math.min(room.width, room.length) >= this.MinGableRoof) {
                return desired;
            }
            if (this.hasFlatRoof && Math.min(room.width, room.length) >= this.MinFlatRoof) {
                return DesignType.FLAT_ROOF;
            }
            return DesignType.NONE;
        }
        if (!tower && desired == DesignType.FLAT_ROOF) {
            if (this.hasFlatRoof) {
                return desired;
            }
            return DesignType.NONE;
        }
        if (tower && desired == DesignType.ROOF) {
            if (this.hasConicalRoof && room.width <= this.MaxConicalRoofRadius * 2 + 1) {
                return desired;
            }
            if (this.hasFlatTowerRoof) {
                return DesignType.FLAT_ROOF;
            }
            return DesignType.NONE;
        }
        if (tower && desired == DesignType.FLAT_ROOF) {
            if (this.hasFlatTowerRoof) {
                return desired;
            }
            return DesignType.NONE;
        }
        return DesignType.NONE;
    }
}

