/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.ThemeStatistics;
import com.simibubi.mightyarchitect.foundation.utility.DesignHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ThemeValidator {
    static List<StringTextComponent> complaints;

    public static void check(DesignTheme theme) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        player.func_145747_a((ITextComponent)new StringTextComponent(" "));
        player.func_145747_a((ITextComponent)new StringTextComponent(" "));
        player.func_145747_a((ITextComponent)new StringTextComponent(" "));
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "--> Validation on " + TextFormatting.BLUE + TextFormatting.BOLD + theme.getDisplayName() + TextFormatting.AQUA + " <--"));
        theme.clearDesigns();
        ThemeStatistics stats = theme.getStatistics();
        stats.sendToPlayer();
        complaints = new LinkedList<StringTextComponent>();
        for (DesignLayer designLayer : theme.getLayers()) {
            block10: for (DesignType type : theme.getTypes()) {
                if (theme.getRoomLayers().contains((Object)designLayer) && DesignType.roofTypes().contains((Object)type) || !theme.getRoomLayers().contains((Object)designLayer) && !DesignType.roofTypes().contains((Object)type)) continue;
                DesignQuery query = new DesignQuery(theme, designLayer, type);
                if (!ThemeValidator.exists(query)) {
                    if (type == DesignType.FACADE || type == DesignType.CORNER && designLayer == DesignLayer.Open) continue;
                    ThemeValidator.alert(designLayer.getDisplayName() + " " + type.getDisplayName() + " has no designs!");
                    continue;
                }
                ArrayList<Integer> missingHeights = new ArrayList<Integer>();
                block0 : switch (type) {
                    case CORNER: {
                        missingHeights.clear();
                        for (int height = 1; height <= theme.getMaxFloorHeight(); ++height) {
                            DesignQuery cornerQuery = new DesignQuery(theme, designLayer, type).withHeight(height);
                            if (ThemeValidator.exists(cornerQuery)) continue;
                            missingHeights.add(height);
                        }
                        if (missingHeights.isEmpty()) break;
                        ThemeValidator.alert(designLayer.getDisplayName() + " " + type.getDisplayName() + "s are missing heights " + ThemeValidator.glue(missingHeights));
                        break;
                    }
                    case NONE: {
                        ThemeValidator.alert("Found design with no type in layer " + designLayer.getDisplayName() + "!");
                        break;
                    }
                    case ROOF: 
                    case FLAT_ROOF: {
                        for (int span = stats.MinGableRoof; span <= stats.MaxGableRoof; span += 2) {
                            DesignQuery roofQuery = new DesignQuery(theme, designLayer, type).withWidth(span);
                            if (ThemeValidator.exists(roofQuery)) continue;
                            ThemeValidator.alert("No " + type.getDisplayName() + " has a span of " + span + "m.");
                        }
                        continue block10;
                    }
                    case TOWER: {
                        int height;
                        int radius;
                        for (radius = stats.MinTowerRadius; radius <= stats.MaxTowerRadius; ++radius) {
                            DesignQuery withWidth = new DesignQuery(theme, designLayer, type).withWidth(radius * 2 + 1);
                            if (!ThemeValidator.exists(withWidth)) {
                                ThemeValidator.alert("No " + designLayer.getDisplayName() + " " + type.getDisplayName() + " has radius " + radius + "m.");
                                continue;
                            }
                            missingHeights.clear();
                            for (height = 1; height <= theme.getMaxFloorHeight(); ++height) {
                                DesignQuery towerQuery = withWidth.withHeight(height);
                                if (ThemeValidator.exists(towerQuery)) continue;
                                missingHeights.add(height);
                            }
                            if (missingHeights.isEmpty()) continue;
                            ThemeValidator.alert(designLayer.getDisplayName() + " " + type.getDisplayName() + "s with radius " + radius + " are missing heights " + ThemeValidator.glue(missingHeights));
                        }
                        continue block10;
                    }
                    case TOWER_FLAT_ROOF: {
                        DesignQuery towerQuery;
                        int radius;
                        for (radius = stats.MinTowerRadius; radius <= stats.MaxTowerRadius; ++radius) {
                            towerQuery = new DesignQuery(theme, designLayer, type).withWidth(radius * 2 + 1);
                            if (ThemeValidator.exists(towerQuery)) continue;
                            ThemeValidator.alert("No " + type.getDisplayName() + " has a radius of " + radius + "m.");
                        }
                        continue block10;
                    }
                    case TOWER_ROOF: {
                        DesignQuery towerQuery;
                        int radius;
                        for (radius = stats.MinTowerRadius; radius <= stats.MaxConicalRoofRadius; ++radius) {
                            towerQuery = new DesignQuery(theme, designLayer, type).withWidth(radius * 2 + 1);
                            if (ThemeValidator.exists(towerQuery)) continue;
                            ThemeValidator.alert("No " + type.getDisplayName() + " has a radius of " + radius + "m.");
                        }
                        continue block10;
                    }
                    case WALL: {
                        int height;
                        for (int width = stats.MinRoomLength - 2; width <= 15; width += 2) {
                            DesignQuery wallQuery = new DesignQuery(theme, designLayer, type).withWidth(width);
                            if (!ThemeValidator.exists(wallQuery)) {
                                ThemeValidator.alert("No " + designLayer.getDisplayName() + " " + type.getDisplayName() + " spans " + width + "m.");
                                break block0;
                            }
                            missingHeights.clear();
                            for (height = 1; height <= theme.getMaxFloorHeight(); ++height) {
                                if (ThemeValidator.exists(wallQuery.withHeight(height))) continue;
                                missingHeights.add(height);
                            }
                            if (missingHeights.isEmpty()) continue;
                            ThemeValidator.alert(designLayer.getDisplayName() + " " + type.getDisplayName() + "s which span " + width + " are missing heights " + ThemeValidator.glue(missingHeights));
                        }
                        continue block10;
                    }
                }
            }
        }
        if (complaints.size() > 0) {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "The Following Designs are missing:"));
            for (ITextComponent iTextComponent : complaints) {
                player.func_145747_a(iTextComponent);
            }
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Try and add these missing designs or exclude their type from your theme."));
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "For prior traits no missing designs have been found."));
        }
    }

    private static boolean exists(DesignQuery query) {
        return DesignHelper.pickRandom(query.withoutFallback(), new Random()) != null;
    }

    private static void alert(String message) {
        complaints.add(new StringTextComponent("-> " + TextFormatting.RED + message));
    }

    private static String glue(List<Integer> heights) {
        if (heights.isEmpty()) {
            return null;
        }
        String s = "";
        for (int h : heights) {
            s = s + ", " + h;
        }
        return s.substring(2);
    }
}

