/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.palette;

import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;

public enum BlockOrientation {
    NONE(null, null),
    TOP(Half.TOP, null),
    BOTTOM(Half.BOTTOM, null),
    UP(null, Direction.UP),
    DOWN(null, Direction.DOWN),
    NORTH(null, Direction.NORTH),
    SOUTH(null, Direction.SOUTH),
    EAST(null, Direction.EAST),
    WEST(null, Direction.WEST),
    TOP_UP(Half.TOP, Direction.UP),
    TOP_DOWN(Half.TOP, Direction.DOWN),
    TOP_NORTH(Half.TOP, Direction.NORTH),
    TOP_SOUTH(Half.TOP, Direction.SOUTH),
    TOP_EAST(Half.TOP, Direction.EAST),
    TOP_WEST(Half.TOP, Direction.WEST),
    BOTTOM_UP(Half.BOTTOM, Direction.UP),
    BOTTOM_DOWN(Half.BOTTOM, Direction.DOWN),
    BOTTOM_NORTH(Half.BOTTOM, Direction.NORTH),
    BOTTOM_SOUTH(Half.BOTTOM, Direction.SOUTH),
    BOTTOM_EAST(Half.BOTTOM, Direction.EAST),
    BOTTOM_WEST(Half.BOTTOM, Direction.WEST);

    private Half half;
    private Direction facing;

    private BlockOrientation(Half half, Direction facing) {
        this.half = half;
        this.facing = facing;
    }

    public static BlockOrientation valueOf(Half half, Direction facing) {
        for (BlockOrientation e : BlockOrientation.values()) {
            if (e.half != half || e.facing != facing) continue;
            return e;
        }
        return NONE;
    }

    public BlockOrientation withRotation(int angle) {
        if (!this.hasFacing()) {
            return this;
        }
        if (this.facing.func_176736_b() == -1) {
            return this;
        }
        Direction facing2 = this.facing;
        while (angle > -360) {
            facing2 = facing2.func_176746_e();
            angle -= 90;
        }
        return BlockOrientation.valueOf(this.half, facing2);
    }

    public BlockOrientation withMirror(Direction.Axis axis) {
        if (!this.hasFacing() || this.facing.func_176740_k() != axis) {
            return this;
        }
        return BlockOrientation.valueOf(this.half, this.facing.func_176734_d());
    }

    public static BlockOrientation byState(BlockState state) {
        Half half = null;
        Direction facing = null;
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q)) {
            half = (Half)state.func_177229_b((IProperty)BlockStateProperties.field_208164_Q);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208145_at) && state.func_177229_b((IProperty)BlockStateProperties.field_208145_at) != SlabType.DOUBLE) {
            Half half2 = half = state.func_177229_b((IProperty)BlockStateProperties.field_208145_at) == SlabType.BOTTOM ? Half.BOTTOM : Half.TOP;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208156_I)) {
            facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208156_I);
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        }
        if (state.func_177230_c() instanceof TrapDoorBlock) {
            facing = facing.func_176734_d();
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208148_A)) {
            facing = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A)));
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208199_z)) {
            facing = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z)));
        }
        return BlockOrientation.valueOf(half, facing);
    }

    public static BlockOrientation valueOf(char character) {
        return BlockOrientation.values()[character - 65];
    }

    public char asChar() {
        return (char)(65 + this.ordinal());
    }

    public BlockState apply(BlockState state, boolean forceAxis) {
        Direction.Axis axis;
        BlockState newState = state;
        newState = newState.func_185907_a(this.getRotation());
        if (this.hasHalf() && state.func_196959_b((IProperty)BlockStateProperties.field_208164_Q)) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208164_Q, (Comparable)this.half);
        }
        if (this.hasHalf() && state.func_196959_b((IProperty)SlabBlock.field_196505_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE) {
            newState = (BlockState)newState.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)(this.half == Half.TOP ? SlabType.TOP : SlabType.BOTTOM));
        }
        if (this.hasFacing() && state.func_196959_b((IProperty)BlockStateProperties.field_208155_H) && ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k().func_200128_b() && forceAxis) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)this.facing);
        }
        if (this.hasFacing() && state.func_196959_b((IProperty)BlockStateProperties.field_208156_I) && ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208156_I)).func_176740_k().func_200128_b() && forceAxis) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208156_I, (Comparable)this.facing);
        }
        if (this.hasFacing() && state.func_196959_b((IProperty)BlockStateProperties.field_208148_A) && (axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208148_A)) == Direction.Axis.Y && forceAxis) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)this.facing.func_176740_k());
        }
        if (this.hasFacing() && state.func_196959_b((IProperty)BlockStateProperties.field_208199_z) && (axis = (Direction.Axis)state.func_177229_b((IProperty)BlockStateProperties.field_208199_z)) == Direction.Axis.Y && forceAxis) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)this.facing.func_176740_k());
        }
        return newState;
    }

    private Rotation getRotation() {
        if (!this.hasFacing()) {
            return Rotation.NONE;
        }
        switch (this.facing) {
            case EAST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case NORTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public boolean hasFacing() {
        return this.facing != null;
    }

    public boolean hasHalf() {
        return this.half != null;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public Half getHalf() {
        return this.half;
    }

    public String toString() {
        return "Orientation: " + (this.hasHalf() ? this.half.func_176610_l() + " " : "Solid ") + (this.hasFacing() ? this.facing.func_176610_l() : "");
    }

    public BlockState apply(BlockState iBlockState) {
        return this.apply(iBlockState, false);
    }
}

