/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.compose.planner.Tools;
import com.simibubi.mightyarchitect.control.phase.IRenderGameOverlay;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import com.simibubi.mightyarchitect.foundation.utility.ShaderManager;
import com.simibubi.mightyarchitect.foundation.utility.Shaders;
import com.simibubi.mightyarchitect.gui.ToolSelectionScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class PhaseComposing
extends PhaseBase
implements IRenderGameOverlay {
    private Tools activeTool;
    private ToolSelectionScreen toolSelection;

    @Override
    public void whenEntered() {
        this.activeTool = Tools.Room;
        this.activeTool.getTool().init();
        List<Tools> groundPlanningTools = Tools.getGroundPlanningTools();
        if (!this.getModel().getTheme().getStatistics().hasTowers) {
            groundPlanningTools.remove((Object)Tools.Cylinder);
        }
        this.toolSelection = new ToolSelectionScreen(groundPlanningTools, this::equipTool);
        ShaderManager.setActiveShader(Shaders.Blueprint);
    }

    private void equipTool(Tools tool) {
        if (tool == this.activeTool) {
            return;
        }
        this.activeTool = tool;
        this.activeTool.getTool().init();
    }

    @Override
    public void update() {
        this.activeTool.getTool().updateSelection();
        this.toolSelection.update();
        this.activeTool.getTool().tickGroundPlanOutlines();
        this.activeTool.getTool().tickToolOutlines();
    }

    @Override
    public void onClick(int button) {
        if (button != 1) {
            return;
        }
        String message = this.activeTool.getTool().handleRightClick();
        this.sendStatusMessage(message);
    }

    @Override
    public void onKey(int key, boolean released) {
        if (key != MightyClient.TOOL_MENU.getKey().func_197937_c()) {
            return;
        }
        if (released && this.toolSelection.focused) {
            this.toolSelection.focused = false;
            this.toolSelection.onClose();
        }
        if (!released && !this.toolSelection.focused) {
            this.toolSelection.focused = true;
        }
    }

    @Override
    public boolean onScroll(int amount) {
        if (this.toolSelection.focused) {
            this.toolSelection.cycle(amount);
            return true;
        }
        return this.activeTool.getTool().handleMouseWheel(amount);
    }

    @Override
    public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
    }

    @Override
    public void whenExited() {
        ShaderManager.stopUsingShaders();
    }

    @Override
    public void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        this.toolSelection.renderPassive(event.getPartialTicks());
        this.activeTool.getTool().renderOverlay();
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Draw the layout of your build, adding rooms, towers and other. Modify their position, size and roof using the Tools.");
    }
}

