/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.phase.IDrawBlockHighlights;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import com.simibubi.mightyarchitect.foundation.utility.RaycastHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class PhaseCreatingPalette
extends PhaseBase
implements IDrawBlockHighlights {
    private PaletteDefinition palette;
    private BlockPos center;
    private Map<BlockPos, Palette> grid;
    private boolean[] changed;
    static final Object textKey = new Object();

    @Override
    public void whenEntered() {
        Schematic model = this.getModel();
        ClientWorld world = this.minecraft.field_71441_e;
        this.changed = new boolean[16];
        this.palette = model.getCreatedPalette();
        this.center = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, this.minecraft.field_71439_g.func_180425_c());
        this.grid = new HashMap<BlockPos, Palette>();
        for (int i = 0; i < 16; ++i) {
            BlockPos pos = this.positionFromIndex(i);
            this.grid.put(pos, Palette.values()[i]);
            if (world.func_175623_d(pos) || this.palette.get(Palette.values()[i]) == world.func_180495_p(pos)) continue;
            this.palette.put(Palette.values()[i], world.func_180495_p(pos));
            this.changed[i] = true;
        }
        model.updatePalettePreview();
        MightyClient.renderer.display(this.getModel());
    }

    @Override
    public void update() {
        for (int i = 0; i < 16; ++i) {
            BlockPos pos = this.positionFromIndex(i);
            if (this.minecraft.field_71441_e.func_175623_d(pos)) {
                Palette key;
                PaletteDefinition paletteDef = this.getModel().isEditingPrimary() ? this.getModel().getPrimary() : this.getModel().getSecondary();
                if (paletteDef.get(key = this.grid.get(pos)) == this.palette.get(key)) continue;
                this.palette.put(key, paletteDef.get(key));
                this.changed[i] = false;
                this.notifyChange();
                continue;
            }
            BlockState state = this.minecraft.field_71441_e.func_180495_p(pos);
            if (state.func_177230_c() instanceof TrapDoorBlock) {
                state = (BlockState)state.func_206870_a((IProperty)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf(true));
            }
            if (this.palette.get(Palette.values()[i]) == state) continue;
            this.palette.put(this.grid.get(pos), state);
            this.changed[i] = true;
            this.notifyChange();
        }
    }

    @Override
    public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
        for (int i = 0; i < 16; ++i) {
            BlockState state = this.palette.get(Palette.values()[i]);
            if (state == null || this.changed[i]) continue;
            ms.func_227860_a_();
            BlockPos translate = this.positionFromIndex(i);
            ms.func_227861_a_((double)translate.func_177958_n(), (double)translate.func_177956_o(), (double)translate.func_177952_p());
            ms.func_227861_a_(0.03125, 0.03125, 0.03125);
            ms.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
            this.minecraft.func_175602_ab().renderBlock(state, ms, buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
    }

    @Override
    public void whenExited() {
        this.getModel().stopPalettePreview();
        MightyClient.renderer.setActive(false);
    }

    protected void notifyChange() {
        this.getModel().updatePalettePreview();
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Updating Preview..."), true);
        MightyClient.renderer.update();
    }

    @Override
    public void tickHighlightOutlines() {
        BlockPos targetBlock = null;
        BlockRayTraceResult raytrace = RaycastHelper.rayTraceRange((World)this.minecraft.field_71441_e, (PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e());
        if (raytrace != null && raytrace.func_216346_c() == RayTraceResult.Type.BLOCK && this.grid.containsKey(targetBlock = new BlockPos(raytrace.func_216347_e()))) {
            this.sendStatusMessage(this.grid.get(targetBlock).getDisplayName());
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos pos = this.positionFromIndex(i);
            boolean s = targetBlock != null && pos.equals((Object)targetBlock);
            boolean b = this.changed[i];
            MightyClient.outliner.showAABB("pallete" + i, new AxisAlignedBB(pos)).lineWidth(b || s ? 0.0625f : 0.03125f).colored(s ? 0x8888FF : (b ? 0x6666FF : 0xBBBBBB));
        }
    }

    private BlockPos positionFromIndex(int index) {
        return this.center.func_177965_g(-3 + index % 4 * 2).func_177970_e(-3 + index / 4 * 2);
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"The Ghost blocks show the individual materials used in this build.", (Object)"Modify the palette by placing blocks into the marked areas. You do not have to fill all the gaps.", (Object)"Once finished, make sure to save it. [F]");
    }
}

