/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.TemplateBlockAccess;
import com.simibubi.mightyarchitect.control.phase.ArchitectPhases;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PrintingToMultiplayer
extends PhaseBase {
    static List<BlockPos> remaining;
    static int cooldown;
    static boolean approved;

    @Override
    public void whenEntered() {
        remaining = new LinkedList<BlockPos>(((TemplateBlockAccess)this.getModel().getMaterializedSketch()).getAllPositions());
        remaining.sort((o1, o2) -> Integer.compare(o1.func_177956_o(), o2.func_177956_o()));
        Minecraft.func_71410_x().field_71439_g.func_71165_d("/setblock checking permission for 'The Mighty Architect'.");
        cooldown = 500;
        approved = false;
    }

    @Override
    public void update() {
        if (cooldown > 0 && !approved) {
            --cooldown;
            return;
        }
        if (cooldown == 0) {
            ArchitectManager.enterPhase(ArchitectPhases.Previewing);
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (!remaining.isEmpty()) {
                BlockPos pos = remaining.get(0);
                remaining.remove(0);
                pos = pos.func_177971_a((Vec3i)this.getModel().getAnchor());
                BlockState state = this.getModel().getMaterializedSketch().func_180495_p(pos);
                if (this.minecraft.field_71441_e.func_180495_p(pos) == state || !this.minecraft.field_71441_e.func_226663_a_(state, pos, ISelectionContext.func_216374_a((Entity)this.minecraft.field_71439_g))) continue;
                String blockstring = state.toString().replaceFirst("Block\\{", "").replaceFirst("\\}", "");
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/setblock " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p() + " " + blockstring);
                continue;
            }
            ArchitectManager.unload();
            break;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onCommandFeedback(ClientChatReceivedEvent event) {
        if (event.getMessage() == null) {
            return;
        }
        if (cooldown > 0) {
            LinkedList<ITextComponent> checking = new LinkedList<ITextComponent>();
            checking.add(event.getMessage());
            while (!checking.isEmpty()) {
                ITextComponent iTextComponent = (ITextComponent)checking.get(0);
                if (iTextComponent instanceof TranslationTextComponent) {
                    String test = ((TranslationTextComponent)iTextComponent).func_150268_i();
                    if (test.equals("command.unknown.command")) {
                        cooldown = 0;
                        event.setMessage((ITextComponent)new StringTextComponent(TextFormatting.RED + "You do not have permission to print on this server."));
                        return;
                    }
                    if (test.equals("parsing.int.expected")) {
                        approved = true;
                        Minecraft.func_71410_x().field_71439_g.func_71165_d("/me is printing a structure created by the Mighty Architect.");
                        Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamerule sendCommandFeedback false");
                        Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamerule logAdminCommands false");
                        event.setCanceled(true);
                        return;
                    }
                } else {
                    checking.addAll(iTextComponent.func_150253_a());
                }
                checking.remove(iTextComponent);
            }
        }
    }

    @Override
    public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
    }

    @Override
    public void whenExited() {
        if (approved) {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Finished Printing, enjoy!"), false);
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamerule logAdminCommands true");
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/gamerule sendCommandFeedback true");
        }
        cooldown = 0;
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Please be patient while your building is being transferred.");
    }
}

