/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import com.simibubi.mightyarchitect.foundation.SpriteShiftEntry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class SuperByteBuffer {
    protected ByteBuffer template;
    protected int formatSize;
    private MatrixStack transforms;
    private boolean shouldShiftUV;
    private SpriteShiftEntry spriteShift;
    private float uTarget;
    private float vTarget;
    private boolean shouldLight;
    private int packedLightCoords;
    private Matrix4f lightTransform;
    private boolean shouldColor;
    private int r;
    private int g;
    private int b;
    private int a;
    private float sheetSize;

    public SuperByteBuffer(BufferBuilder buf) {
        Pair state = buf.func_227832_f_();
        ByteBuffer rendered = (ByteBuffer)state.getSecond();
        rendered.order(ByteOrder.nativeOrder());
        this.formatSize = buf.getVertexFormat().func_177338_f();
        int size = ((BufferBuilder.DrawState)state.getFirst()).func_227839_b_() * this.formatSize;
        this.template = GLAllocation.func_74524_c((int)size);
        this.template.order(rendered.order());
        this.template.limit(rendered.limit());
        this.template.put(rendered);
        this.template.rewind();
        this.transforms = new MatrixStack();
    }

    public static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.func_94212_f() - sprite.func_94209_e();
        return (u - sprite.func_94209_e()) / f * 16.0f;
    }

    public static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.func_94210_h() - sprite.func_94206_g();
        return (v - sprite.func_94206_g()) / f * 16.0f;
    }

    public void renderInto(MatrixStack input, IVertexBuilder builder) {
        ByteBuffer buffer = this.template;
        if (buffer.limit() == 0) {
            return;
        }
        buffer.rewind();
        Matrix4f t = input.func_227866_c_().func_227870_a_().func_226601_d_();
        Matrix4f localTransforms = this.transforms.func_227866_c_().func_227870_a_();
        t.func_226595_a_(localTransforms);
        for (int i = 0; i < this.vertexCount(buffer); ++i) {
            float x = this.getX(buffer, i);
            float y = this.getY(buffer, i);
            float z = this.getZ(buffer, i);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            Vector4f lightPos = new Vector4f(x, y, z, 1.0f);
            pos.func_229372_a_(t);
            lightPos.func_229372_a_(localTransforms);
            builder.func_225582_a_((double)pos.func_195910_a(), (double)pos.func_195913_b(), (double)pos.func_195914_c());
            int r = this.getR(buffer, i);
            byte g = this.getG(buffer, i);
            byte b = this.getB(buffer, i);
            byte a = this.getA(buffer, i);
            if (this.shouldColor) {
                float lum = (float)(r < 0 ? 255 + r : r) / 256.0f;
                builder.func_225586_a_((int)((float)this.r * lum), (int)((float)this.g * lum), (int)((float)this.b * lum), this.a);
            } else {
                builder.func_225586_a_(r, (int)g, (int)b, (int)a);
            }
            float u = this.getU(buffer, i);
            float v = this.getV(buffer, i);
            if (this.shouldShiftUV) {
                float targetU = this.spriteShift.getTarget().func_94214_a((double)(SuperByteBuffer.getUnInterpolatedU(this.spriteShift.getOriginal(), u) / this.sheetSize + this.uTarget * 16.0f));
                float targetV = this.spriteShift.getTarget().func_94207_b((double)(SuperByteBuffer.getUnInterpolatedV(this.spriteShift.getOriginal(), v) / this.sheetSize + this.vTarget * 16.0f));
                builder.func_225583_a_(targetU, targetV);
            } else {
                builder.func_225583_a_(u, v);
            }
            if (this.shouldLight) {
                int light = this.packedLightCoords;
                if (this.lightTransform != null) {
                    lightPos.func_229372_a_(this.lightTransform);
                    light = SuperByteBuffer.getLight((World)Minecraft.func_71410_x().field_71441_e, lightPos);
                }
                builder.func_227886_a_(light);
            } else {
                builder.func_227886_a_(this.getLight(buffer, i));
            }
            builder.func_225584_a_((float)this.getNX(buffer, i), (float)this.getNY(buffer, i), (float)this.getNZ(buffer, i)).func_181675_d();
        }
        this.transforms = new MatrixStack();
        this.shouldShiftUV = false;
        this.shouldColor = false;
        this.shouldLight = false;
    }

    public SuperByteBuffer translate(double x, double y, double z) {
        return this.translate((float)x, (float)y, (float)z);
    }

    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.func_227861_a_((double)x, (double)y, (double)z);
        return this;
    }

    public SuperByteBuffer rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        this.transforms.func_227863_a_(axis.func_229386_k_().func_229193_c_(radians));
        return this;
    }

    public SuperByteBuffer rotateCentered(Direction axis, float radians) {
        return this.translate(0.5f, 0.5f, 0.5f).rotate(axis, radians).translate(-0.5f, -0.5f, -0.5f);
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.shouldShiftUV = true;
        this.spriteShift = entry;
        this.uTarget = 0.0f;
        this.vTarget = 0.0f;
        this.sheetSize = 1.0f;
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.shouldShiftUV = true;
        this.spriteShift = entry;
        this.uTarget = uTarget;
        this.vTarget = vTarget;
        this.sheetSize = sheetSize;
        return this;
    }

    public SuperByteBuffer light(int packedLightCoords) {
        this.shouldLight = true;
        this.lightTransform = null;
        this.packedLightCoords = packedLightCoords;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform) {
        this.shouldLight = true;
        this.lightTransform = lightTransform;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    protected int vertexCount(ByteBuffer buffer) {
        return buffer.limit() / this.formatSize;
    }

    protected int getBufferPosition(int vertexIndex) {
        return vertexIndex * this.formatSize;
    }

    protected float getX(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index));
    }

    protected float getY(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 4);
    }

    protected float getZ(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 8);
    }

    protected byte getR(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 12);
    }

    protected byte getG(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 13);
    }

    protected byte getB(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 14);
    }

    protected byte getA(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 15);
    }

    protected float getU(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 16);
    }

    protected float getV(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 20);
    }

    protected int getLight(ByteBuffer buffer, int index) {
        return buffer.getInt(this.getBufferPosition(index) + 24);
    }

    protected byte getNX(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 28);
    }

    protected byte getNY(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 29);
    }

    protected byte getNZ(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 30);
    }

    private static int getLight(World world, Vector4f lightPos) {
        float offset;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        float sky = 0.0f;
        float block = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.func_189532_c((double)(lightPos.func_195910_a() + xOffset), (double)(lightPos.func_195913_b() + yOffset), (double)(lightPos.func_195914_c() + zOffset));
                    sky += (float)world.func_226658_a_(LightType.SKY, (BlockPos)pos) / 8.0f;
                    block += (float)world.func_226658_a_(LightType.BLOCK, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return (int)sky << 20 | (int)block << 4;
    }

    public static interface IVertexLighter {
        public int getPackedLight(float var1, float var2, float var3);
    }
}

