/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.mightyarchitect.foundation.SuperByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SuperByteBufferCache {
    public static final Compartment<BlockState> GENERIC_TILE = new Compartment();
    Map<Compartment<?>, Cache<Object, SuperByteBuffer>> cache = new HashMap();

    public SuperByteBufferCache() {
        this.registerCompartment(GENERIC_TILE);
    }

    public SuperByteBuffer renderBlock(BlockState toRender) {
        return this.getGeneric(toRender, () -> this.standardBlockRender(toRender));
    }

    public SuperByteBuffer renderBlockIn(Compartment<BlockState> compartment, BlockState toRender) {
        return this.get(compartment, toRender, () -> this.standardBlockRender(toRender));
    }

    SuperByteBuffer getGeneric(BlockState key, Supplier<SuperByteBuffer> supplier) {
        return this.get(GENERIC_TILE, key, supplier);
    }

    public <T> SuperByteBuffer get(Compartment<T> compartment, T key, Supplier<SuperByteBuffer> supplier) {
        Cache<Object, SuperByteBuffer> compartmentCache = this.cache.get(compartment);
        try {
            return (SuperByteBuffer)compartmentCache.get(key, supplier::get);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void registerCompartment(Compartment<?> instance) {
        this.cache.put(instance, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().build());
    }

    public void registerCompartment(Compartment<?> instance, long ticksTillExpired) {
        this.cache.put(instance, (Cache<Object, SuperByteBuffer>)CacheBuilder.newBuilder().expireAfterAccess(ticksTillExpired * 50L, TimeUnit.MILLISECONDS).build());
    }

    private SuperByteBuffer standardBlockRender(BlockState renderedState) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        return this.standardModelRender(dispatcher.func_184389_a(renderedState), renderedState);
    }

    private SuperByteBuffer standardModelRender(IBakedModel model, BlockState referenceState) {
        return this.standardModelRender(model, referenceState, new MatrixStack());
    }

    private SuperByteBuffer standardModelRender(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        Random random = new Random();
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        blockRenderer.renderModelFlat((ILightReader)Minecraft.func_71410_x().field_71441_e, model, referenceState, BlockPos.field_177992_a.func_177981_b(255), ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        builder.func_178977_d();
        return new SuperByteBuffer(builder);
    }

    public void invalidate() {
        this.cache.forEach((comp, cache) -> cache.invalidateAll());
    }

    public static class Compartment<T> {
    }
}

