/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation.utility;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RaycastHelper {
    public static BlockRayTraceResult rayTraceRange(World worldIn, PlayerEntity playerIn, double range) {
        Vec3d origin = RaycastHelper.getTraceOrigin(playerIn);
        Vec3d target = RaycastHelper.getTraceTarget(playerIn, range, origin);
        RayTraceContext context = new RayTraceContext(origin, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)playerIn);
        return worldIn.func_217299_a(context);
    }

    public static PredicateTraceResult rayTraceUntil(PlayerEntity playerIn, double range, Predicate<BlockPos> predicate) {
        Vec3d origin = RaycastHelper.getTraceOrigin(playerIn);
        Vec3d target = RaycastHelper.getTraceTarget(playerIn, range, origin);
        return RaycastHelper.rayTraceUntil(origin, target, predicate);
    }

    private static Vec3d getTraceTarget(PlayerEntity playerIn, double range, Vec3d origin) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = range;
        Vec3d vec3d1 = origin.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return vec3d1;
    }

    private static Vec3d getTraceOrigin(PlayerEntity playerIn) {
        double d0 = playerIn.func_226277_ct_();
        double d1 = playerIn.func_226278_cu_() + (double)playerIn.func_70047_e();
        double d2 = playerIn.func_226281_cx_();
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        return vec3d;
    }

    private static PredicateTraceResult rayTraceUntil(Vec3d start, Vec3d end, Predicate<BlockPos> predicate) {
        int z;
        int y;
        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
            return null;
        }
        int dx = MathHelper.func_76128_c((double)end.field_72450_a);
        int dy = MathHelper.func_76128_c((double)end.field_72448_b);
        int dz = MathHelper.func_76128_c((double)end.field_72449_c);
        int x = MathHelper.func_76128_c((double)start.field_72450_a);
        BlockPos currentPos = new BlockPos(x, y = MathHelper.func_76128_c((double)start.field_72448_b), z = MathHelper.func_76128_c((double)start.field_72449_c));
        if (predicate.test(currentPos)) {
            return new PredicateTraceResult(currentPos, Direction.func_176737_a((float)(dx - x), (float)(dy - y), (float)(dz - z)));
        }
        int remainingDistance = 200;
        while (remainingDistance-- >= 0) {
            Direction enumfacing;
            if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                return null;
            }
            if (x == dx && y == dy && z == dz) {
                return new PredicateTraceResult();
            }
            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (dx > x) {
                d0 = (double)x + 1.0;
            } else if (dx < x) {
                d0 = (double)x + 0.0;
            } else {
                flag2 = false;
            }
            if (dy > y) {
                d1 = (double)y + 1.0;
            } else if (dy < y) {
                d1 = (double)y + 0.0;
            } else {
                flag = false;
            }
            if (dz > z) {
                d2 = (double)z + 1.0;
            } else if (dz < z) {
                d2 = (double)z + 0.0;
            } else {
                flag1 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.field_72450_a - start.field_72450_a;
            double d7 = end.field_72448_b - start.field_72448_b;
            double d8 = end.field_72449_c - start.field_72449_c;
            if (flag2) {
                d3 = (d0 - start.field_72450_a) / d6;
            }
            if (flag) {
                d4 = (d1 - start.field_72448_b) / d7;
            }
            if (flag1) {
                d5 = (d2 - start.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = dx > x ? Direction.WEST : Direction.EAST;
                start = new Vec3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = dy > y ? Direction.DOWN : Direction.UP;
                start = new Vec3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
            } else {
                enumfacing = dz > z ? Direction.NORTH : Direction.SOUTH;
                start = new Vec3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
            }
            if (!predicate.test(currentPos = new BlockPos(x = MathHelper.func_76128_c((double)start.field_72450_a) - (enumfacing == Direction.EAST ? 1 : 0), y = MathHelper.func_76128_c((double)start.field_72448_b) - (enumfacing == Direction.UP ? 1 : 0), z = MathHelper.func_76128_c((double)start.field_72449_c) - (enumfacing == Direction.SOUTH ? 1 : 0)))) continue;
            return new PredicateTraceResult(currentPos, enumfacing);
        }
        return new PredicateTraceResult();
    }

    public static class PredicateTraceResult {
        private BlockPos pos;
        private Direction facing;

        public PredicateTraceResult(BlockPos pos, Direction facing) {
            this.pos = pos;
            this.facing = facing;
        }

        public PredicateTraceResult() {
        }

        public Direction getFacing() {
            return this.facing;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean missed() {
            return this.pos == null;
        }
    }
}

