/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation.utility.outliner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.mightyarchitect.AllSpecialTextures;
import com.simibubi.mightyarchitect.foundation.RenderTypes;
import com.simibubi.mightyarchitect.foundation.utility.VecHelper;
import com.simibubi.mightyarchitect.foundation.utility.outliner.Outline;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BlockClusterOutline
extends Outline {
    private Cluster cluster = new Cluster();

    public BlockClusterOutline(Iterable<BlockPos> selection) {
        selection.forEach(this.cluster::include);
    }

    @Override
    public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
        Direction direction;
        for (MergeEntry edge : this.cluster.visibleEdges) {
            Vec3d start = new Vec3d((Vec3i)edge.pos);
            direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)edge.axis);
            this.renderAACuboidLine(ms, buffer, start, new Vec3d((Vec3i)edge.pos.func_177972_a(direction)));
        }
        for (MergeEntry face : this.cluster.visibleFaces.keySet()) {
            Direction.AxisDirection axisDirection = this.cluster.visibleFaces.get(face);
            direction = Direction.func_181076_a((Direction.AxisDirection)axisDirection, (Direction.Axis)face.axis);
            BlockPos pos = face.pos;
            if (axisDirection == Direction.AxisDirection.POSITIVE) {
                pos = pos.func_177972_a(direction.func_176734_d());
            }
            this.renderBlockFace(ms, buffer, pos, direction);
        }
    }

    protected void renderBlockFace(MatrixStack ms, IRenderTypeBuffer buffer, BlockPos pos, Direction face) {
        Optional<AllSpecialTextures> faceTexture = this.params.faceTexture;
        if (!faceTexture.isPresent()) {
            return;
        }
        RenderType translucentType = RenderTypes.getOutlineTranslucent(faceTexture.get().getLocation(), true);
        IVertexBuilder builder = buffer.getBuffer(translucentType);
        Vec3d center = VecHelper.getCenterOf((Vec3i)pos);
        Vec3d offset = new Vec3d(face.func_176730_m());
        Vec3d plane = VecHelper.axisAlingedPlaneOf(offset);
        Direction.Axis axis = face.func_176740_k();
        offset = offset.func_186678_a(0.515625);
        plane = plane.func_186678_a(0.5).func_178787_e(offset);
        int deg = face.func_176743_c().func_179524_a() * 90;
        Vec3d a1 = plane.func_178787_e(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3d a2 = plane.func_178787_e(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3d a3 = plane.func_178787_e(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3d a4 = plane.func_178787_e(center);
        this.putQuad(ms, builder, a1, a2, a3, a4, face);
    }

    private static class MergeEntry {
        Direction.Axis axis;
        BlockPos pos;

        public MergeEntry(Direction.Axis axis, BlockPos pos) {
            this.axis = axis;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeEntry)) {
                return false;
            }
            MergeEntry other = (MergeEntry)o;
            return this.axis == other.axis && this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode() * 31 + this.axis.ordinal();
        }
    }

    private static class Cluster {
        Map<MergeEntry, Direction.AxisDirection> visibleFaces;
        Set<MergeEntry> visibleEdges = new HashSet<MergeEntry>();

        public Cluster() {
            this.visibleFaces = new HashMap<MergeEntry, Direction.AxisDirection>();
        }

        public void include(BlockPos pos) {
            for (Direction.Axis axis : Direction.Axis.values()) {
                Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                int[] nArray = new int[]{0, 1};
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int offset = nArray[i];
                    MergeEntry entry = new MergeEntry(axis, pos.func_177967_a(direction, offset));
                    if (this.visibleFaces.remove(entry) != null) continue;
                    this.visibleFaces.put(entry, offset == 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
                }
            }
            block2: for (Direction.Axis axis : Direction.Axis.values()) {
                for (Direction.Axis axis2 : Direction.Axis.values()) {
                    if (axis == axis2) continue;
                    for (Direction.Axis axis3 : Direction.Axis.values()) {
                        if (axis == axis3 || axis2 == axis3) continue;
                        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis2);
                        Direction direction2 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis3);
                        for (int offset : new int[]{0, 1}) {
                            BlockPos entryPos = pos.func_177967_a(direction, offset);
                            for (int offset2 : new int[]{0, 1}) {
                                MergeEntry entry = new MergeEntry(axis, entryPos = entryPos.func_177967_a(direction2, offset2));
                                if (this.visibleEdges.remove(entry)) continue;
                                this.visibleEdges.add(entry);
                            }
                        }
                    }
                    continue block2;
                }
            }
        }
    }
}

