/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.foundation.utility.outliner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.mightyarchitect.foundation.utility.VecHelper;
import com.simibubi.mightyarchitect.foundation.utility.outliner.Outline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class LineOutline
extends Outline {
    protected Vec3d start = Vec3d.field_186680_a;
    protected Vec3d end = Vec3d.field_186680_a;

    public LineOutline set(Vec3d start, Vec3d end) {
        this.start = start;
        this.end = end;
        return this;
    }

    @Override
    public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
        this.renderCuboidLine(ms, buffer, this.start, this.end);
    }

    public static class EndChasingLineOutline
    extends LineOutline {
        float prevProgress = 0.0f;
        float progress = 0.0f;

        @Override
        public void tick() {
        }

        public EndChasingLineOutline setProgress(float progress) {
            this.prevProgress = this.progress;
            this.progress = progress;
            return this;
        }

        @Override
        public LineOutline set(Vec3d start, Vec3d end) {
            if (!end.equals((Object)this.end)) {
                super.set(start, end);
            }
            return this;
        }

        @Override
        public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
            float pt = Minecraft.func_71410_x().func_184121_ak();
            float distanceToTarget = 1.0f - MathHelper.func_219799_g((float)pt, (float)this.prevProgress, (float)this.progress);
            Vec3d start = this.end.func_178787_e(this.start.func_178788_d(this.end).func_186678_a((double)distanceToTarget));
            this.renderCuboidLine(ms, buffer, start, this.end);
        }
    }

    public static class ChasingLineOutline
    extends LineOutline {
        protected Vec3d prevStart = Vec3d.field_186680_a;
        protected Vec3d prevEnd = Vec3d.field_186680_a;
        protected Vec3d targetStart = Vec3d.field_186680_a;
        protected Vec3d targetEnd = Vec3d.field_186680_a;

        public ChasingLineOutline target(Vec3d start, Vec3d end) {
            if (end.func_72438_d(this.targetStart) + start.func_72438_d(this.targetEnd) < end.func_72438_d(this.targetEnd) + start.func_72438_d(this.targetStart)) {
                this.targetEnd = start;
                this.targetStart = end;
                return this;
            }
            this.targetStart = start;
            this.targetEnd = end;
            return this;
        }

        @Override
        public LineOutline set(Vec3d start, Vec3d end) {
            this.prevEnd = end;
            this.prevStart = start;
            return super.set(start, end);
        }

        @Override
        public void tick() {
            this.prevStart = this.start;
            this.prevEnd = this.end;
            this.start = VecHelper.lerp(this.start, this.targetStart, 0.5);
            this.end = VecHelper.lerp(this.end, this.targetEnd, 0.5);
        }

        @Override
        public void render(MatrixStack ms, IRenderTypeBuffer buffer) {
            float pt = Minecraft.func_71410_x().func_184121_ak();
            this.renderCuboidLine(ms, buffer, VecHelper.lerp(this.prevStart, this.start, pt), VecHelper.lerp(this.prevEnd, this.end, pt));
        }
    }
}

