/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.MightyClient;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.ArchitectMenu;
import com.simibubi.mightyarchitect.control.phase.ArchitectPhases;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ArchitectMenuScreen
extends Screen {
    private ArchitectMenu.KeyBindList keybinds = new ArchitectMenu.KeyBindList();
    private String title = "";
    private List<String> tooltip = new ArrayList<String>();
    private boolean focused = false;
    private boolean visible = false;
    private int menuWidth;
    private int menuHeight;
    private int targetY = 0;
    private float movingY = 0.0f;

    public ArchitectMenuScreen() {
        super((ITextComponent)new StringTextComponent("Architect Menu"));
        this.adjustTarget();
    }

    public void updateContents() {
        Minecraft.func_71410_x().field_71466_p.getClass();
        int fontheight = 9;
        this.tooltip = ArchitectManager.getPhase().getPhaseHandler().getToolTip();
        this.keybinds = ArchitectMenu.getKeybinds();
        this.title = ArchitectManager.getPhase().getDisplayTitle();
        this.menuWidth = 158;
        this.menuHeight = 4;
        this.menuHeight += 12;
        this.menuHeight = (int)((float)this.menuHeight + (4.0f + this.keybinds.size() * (float)fontheight));
        this.menuHeight += 4;
        for (String s : this.tooltip) {
            int lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(s, this.menuWidth - 8).size();
            this.menuHeight += lines * fontheight + 2;
        }
        this.adjustTarget();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.draw(partialTicks);
    }

    public void drawPassive() {
        if (this.isFocused()) {
            return;
        }
        this.draw(Minecraft.func_71410_x().func_184121_ak());
    }

    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean hideOnClose;
        super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        boolean bl = hideOnClose = ArchitectManager.inPhase(ArchitectPhases.Empty) || ArchitectManager.inPhase(ArchitectPhases.Paused);
        if (keyCode == 256) {
            if (hideOnClose) {
                this.setVisible(false);
            }
            this.minecraft.func_147108_a(null);
            return true;
        }
        if (keyCode == MightyClient.COMPOSE.getKey().func_197937_c()) {
            if (hideOnClose) {
                this.setVisible(false);
            }
            this.minecraft.func_147108_a(null);
            return true;
        }
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        boolean hideOnClose;
        boolean bl = hideOnClose = ArchitectManager.inPhase(ArchitectPhases.Empty) || ArchitectManager.inPhase(ArchitectPhases.Paused);
        if (ArchitectMenu.handleMenuInput(p_charTyped_1_)) {
            if (ArchitectManager.inPhase(ArchitectPhases.Paused)) {
                this.setVisible(false);
            }
            this.minecraft.func_147108_a(null);
            return true;
        }
        if (p_charTyped_1_ == 'e') {
            if (hideOnClose) {
                this.setVisible(false);
            }
            this.minecraft.func_147108_a(null);
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    /*
     * Unable to fully structure code
     */
    private void draw(float partialTicks) {
        mainWindow = Minecraft.func_71410_x().func_228018_at_();
        x = mainWindow.func_198107_o() - this.menuWidth - 10;
        y = mainWindow.func_198087_p() - this.menuHeight;
        mouseX = (int)(Minecraft.func_71410_x().field_71417_B.func_198024_e() / mainWindow.func_198100_s());
        mouseY = (int)(Minecraft.func_71410_x().field_71417_B.func_198026_f() / mainWindow.func_198100_s());
        sideways = false;
        if ((mainWindow.func_198107_o() - 182) / 2 < this.menuWidth + 20) {
            sideways = true;
            y -= 24;
        }
        RenderSystem.pushMatrix();
        shift = this.yShift(partialTicks);
        sidewaysShift = shift * ((float)this.menuWidth / (float)this.menuHeight) + (this.focused == false ? 40.0f + (float)this.menuHeight / 4.0f : 0.0f) + 8.0f;
        RenderSystem.translatef((float)(sideways != false ? sidewaysShift : 0.0f), (float)(sideways != false ? 0.0f : shift), (float)0.0f);
        mouseX = (int)((float)mouseX - (sideways != false ? sidewaysShift : 0.0f));
        mouseY = (int)((float)mouseY - (sideways != false ? 0.0f : shift));
        gray = ScreenResources.GRAY;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        ArchitectMenuScreen.blit((int)x, (int)y, (float)gray.startX, (float)gray.startY, (int)this.menuWidth, (int)this.menuHeight, (int)gray.width, (int)gray.height);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        yPos = y + 4;
        xPos = x + 4;
        font = Minecraft.func_71410_x().field_71466_p;
        if (!this.focused) {
            if (sideways) {
                if (this.visible) {
                    string = "Press " + MightyClient.COMPOSE.func_197978_k().toUpperCase() + " for Menu";
                    font.func_175063_a(string, (float)(mainWindow.func_198107_o() - font.func_78256_a(string) - 15) - sidewaysShift, (float)(yPos - 14), 0xEEEEEE);
                }
            } else {
                font.func_175063_a("Press " + MightyClient.COMPOSE.func_197978_k().toUpperCase() + " to focus", (float)xPos, (float)(yPos - 14), 0xEEEEEE);
            }
        } else {
            string = "Press " + MightyClient.COMPOSE.func_197978_k().toUpperCase() + " to close";
            font.func_175063_a(string, sideways != false ? Math.min((float)xPos, (float)(mainWindow.func_198107_o() - font.func_78256_a(string) - 15) - sidewaysShift) : (float)xPos, (float)(yPos - 14), 0xDDDDDD);
        }
        font.func_175063_a(this.title, (float)xPos, (float)yPos, 0xEEEEEE);
        hoveredHorizontally = x <= mouseX && mouseX <= x + this.menuWidth && this.focused != false;
        yPos += 4;
        for (String key : this.keybinds.getKeys()) {
            if (key.isEmpty()) {
                font.getClass();
                yPos += 9 / 2;
                continue;
            }
            font.getClass();
            if (!hoveredHorizontally || (yPos += 9) >= mouseY) ** GOTO lbl-1000
            font.getClass();
            if (mouseY <= yPos + 9) {
                v0 = 0xFFFFFF;
            } else lbl-1000:
            // 2 sources

            {
                v0 = 0xCCDDFF;
            }
            color = v0;
            font.func_175063_a("[" + key + "] " + this.keybinds.get(key), (float)xPos, (float)yPos, color);
            font.func_175063_a(">", (float)(xPos - 12), (float)yPos, color);
        }
        yPos += 4;
        font.getClass();
        yPos += 9;
        for (String text : this.tooltip) {
            lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(text, this.menuWidth - 8).size();
            font.func_78279_b(text, xPos, yPos, this.menuWidth - 8, 0xEEEEEE);
            font.getClass();
            yPos += 9 * lines + 2;
        }
        RenderSystem.popMatrix();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0 || !this.visible || !this.focused) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        int x = mainWindow.func_198107_o() - this.menuWidth - 10;
        int y = mainWindow.func_198087_p() - this.menuHeight;
        boolean sideways = false;
        if ((mainWindow.func_198107_o() - 182) / 2 < this.menuWidth + 20) {
            sideways = true;
            mouseY += 24.0;
        }
        float shift = this.yShift(0.0f);
        mouseY -= sideways ? 0.0 : (double)shift;
        boolean hoveredHorizontally = (double)x <= (mouseX -= sideways ? (double)(shift * 2.0f) : 0.0) && mouseX <= (double)(x + this.menuWidth);
        int yPos = y + 4;
        yPos += 4;
        for (String key : this.keybinds.getKeys()) {
            if (key.isEmpty()) {
                this.font.getClass();
                yPos += 9 / 2;
                continue;
            }
            this.font.getClass();
            yPos += 9;
            if (!hoveredHorizontally || !((double)yPos < mouseY)) continue;
            this.font.getClass();
            if (!(mouseY <= (double)(yPos + 9))) continue;
            this.charTyped(key.toLowerCase().charAt(0), 1);
        }
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        this.adjustTarget();
    }

    protected void adjustTarget() {
        this.targetY = this.visible ? (this.focused ? 0 : this.menuHeight - 14) : this.menuHeight + 20;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.adjustTarget();
    }

    public void removed() {
        super.removed();
        this.setFocused(false);
    }

    private float yShift(float partialTicks) {
        return this.movingY + ((float)this.targetY - this.movingY) * 0.2f * partialTicks;
    }

    public void onClientTick() {
        if (this.movingY != (float)this.targetY) {
            this.movingY = (float)((double)this.movingY + (double)((float)this.targetY - this.movingY) * 0.2);
        }
    }
}

