/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.mightyarchitect.foundation.WrappedWorld;
import com.simibubi.mightyarchitect.foundation.utility.AngleHelper;
import com.simibubi.mightyarchitect.foundation.utility.ColorHelper;
import com.simibubi.mightyarchitect.foundation.utility.Iterate;
import com.simibubi.mightyarchitect.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class GuiGameElement {
    private static FluidRenderWorld renderWorld;

    public static GuiRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(IItemProvider itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(BlockState state) {
        return new GuiBlockStateRenderBuilder(state);
    }

    public static GuiRenderBuilder of(Fluid fluid) {
        return new GuiBlockStateRenderBuilder((BlockState)fluid.func_207188_f().func_206883_i().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(0)));
    }

    private static class FluidRenderWorld
    extends WrappedWorld {
        public FluidRenderWorld(World world) {
            super(world);
        }

        public int func_226658_a_(LightType p_226658_1_, BlockPos p_226658_2_) {
            return 15;
        }

        @Override
        public BlockState func_180495_p(BlockPos pos) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private ItemStack stack;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
        }

        public GuiItemRenderBuilder(IItemProvider provider) {
            this(new ItemStack(provider));
        }

        @Override
        public void render() {
            this.prepare();
            this.transform();
            Minecraft.func_71410_x().func_175599_af().func_175042_a(this.stack, 0, 0);
            this.cleanUp();
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockStateRenderBuilder(BlockState blockstate) {
            super(Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockstate), blockstate);
        }

        @Override
        protected void renderModel(BlockRendererDispatcher blockRenderer, IRenderTypeBuffer.Impl buffer, RenderType renderType, IVertexBuilder vb, MatrixStack ms) {
            if (this.blockState.func_177230_c() instanceof FireBlock) {
                RenderHelper.func_227783_c_();
                blockRenderer.renderBlock(this.blockState, ms, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                RenderHelper.func_227780_a_();
                buffer.func_228461_a_();
                return;
            }
            super.renderModel(blockRenderer, buffer, renderType, vb, ms);
            if (this.blockState.func_204520_s().func_206888_e()) {
                return;
            }
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((IFluidState)this.blockState.func_204520_s(), (RenderType)type)) continue;
                RenderSystem.pushMatrix();
                RenderHelper.func_74518_a();
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (renderWorld == null || renderWorld.func_201672_e() != world) {
                    renderWorld = new FluidRenderWorld((World)world);
                }
                for (Direction d : Iterate.directions) {
                    vb = buffer.getBuffer(type);
                    if (d.func_176743_c() == Direction.AxisDirection.POSITIVE) continue;
                    RenderSystem.pushMatrix();
                    RenderSystem.translated((double)0.5, (double)0.5, (double)0.5);
                    RenderSystem.rotatef((float)AngleHelper.horizontalAngle(d), (float)0.0f, (float)1.0f, (float)0.0f);
                    RenderSystem.rotatef((float)(AngleHelper.verticalAngle(d) - 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    RenderSystem.translated((double)-0.5, (double)-0.5, (double)-0.5);
                    blockRenderer.func_228794_a_(new BlockPos(0, 1, 0), (ILightReader)renderWorld, vb, this.blockState.func_204520_s());
                    buffer.func_228462_a_(type);
                    RenderSystem.popMatrix();
                }
                RenderHelper.func_227780_a_();
                RenderSystem.popMatrix();
                break;
            }
        }
    }

    private static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected IBakedModel blockmodel;
        protected BlockState blockState;

        public GuiBlockModelRenderBuilder(IBakedModel blockmodel, @Nullable BlockState blockState) {
            this.blockState = blockState == null ? Blocks.field_150350_a.func_176223_P() : blockState;
            this.blockmodel = blockmodel;
        }

        @Override
        public void render() {
            this.prepare();
            Minecraft mc = Minecraft.func_71410_x();
            BlockRendererDispatcher blockRenderer = mc.func_175602_ab();
            IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
            RenderType renderType = this.blockState.func_177230_c() == Blocks.field_150350_a ? Atlases.func_228784_i_() : RenderTypeLookup.func_228394_b_((BlockState)this.blockState);
            IVertexBuilder vb = buffer.getBuffer(renderType);
            MatrixStack ms = new MatrixStack();
            this.transform();
            mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            this.renderModel(blockRenderer, buffer, renderType, vb, ms);
            this.cleanUp();
        }

        protected void renderModel(BlockRendererDispatcher blockRenderer, IRenderTypeBuffer.Impl buffer, RenderType renderType, IVertexBuilder vb, MatrixStack ms) {
            Vec3d rgb = ColorHelper.getRGB(this.color);
            blockRenderer.func_175019_b().renderModel(ms.func_227866_c_(), vb, this.blockState, this.blockmodel, (float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            buffer.func_228461_a_();
        }
    }

    public static abstract class GuiRenderBuilder {
        double xBeforeScale;
        double yBeforeScale;
        double x;
        double y;
        double z;
        double xRot;
        double yRot;
        double zRot;
        double scale = 1.0;
        int color = 0xFFFFFF;
        Vec3d rotationOffset = Vec3d.field_186680_a;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public GuiRenderBuilder at(double x, double y) {
            this.xBeforeScale = x;
            this.yBeforeScale = y;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(Vec3d offset) {
            this.rotationOffset = offset;
            return this;
        }

        public abstract void render();

        protected void prepare() {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderHelper.func_227784_d_();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void transform() {
            int verticalFlip = this instanceof GuiItemRenderBuilder ? 1 : -1;
            RenderSystem.translated((double)this.xBeforeScale, (double)this.yBeforeScale, (double)0.0);
            RenderSystem.scaled((double)this.scale, (double)this.scale, (double)this.scale);
            RenderSystem.translated((double)this.x, (double)this.y, (double)this.z);
            RenderSystem.scaled((double)1.0, (double)verticalFlip, (double)1.0);
            RenderSystem.translated((double)this.rotationOffset.field_72450_a, (double)this.rotationOffset.field_72448_b, (double)this.rotationOffset.field_72449_c);
            RenderSystem.rotatef((float)((float)this.zRot), (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.rotatef((float)((float)this.xRot), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)((float)this.yRot), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.translated((double)(-this.rotationOffset.field_72450_a), (double)(-this.rotationOffset.field_72448_b), (double)(-this.rotationOffset.field_72449_c));
        }

        protected void cleanUp() {
            RenderSystem.popMatrix();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
        }
    }
}

