/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.gui.ScreenResources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;

public class ScrollBar
extends AbstractGui {
    protected int x;
    protected int y;
    protected int span;
    protected float position;
    protected float scale;
    protected boolean active;

    public ScrollBar(int x, int span) {
        this.x = x;
        this.y = (-ScreenResources.SCROLLBAR_AXIS.height + Minecraft.func_71410_x().func_228018_at_().func_198087_p()) / 2;
        this.span = span;
        this.scale = (float)span / 200.0f;
        this.position = 1.0f;
        this.active = this.scale > 1.0f;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public void render(Screen screen) {
        if (!this.active) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenResources.SCROLLBAR_AXIS.draw((AbstractGui)screen, this.x, this.y);
        int widgetX = this.x - 6;
        int barSize = (int)(200.0f / (float)this.span * 256.0f);
        int barY = this.y + (int)((1.0f - this.position) * (float)(256 - barSize));
        ScreenResources.SCROLLBAR_CAP.draw((AbstractGui)screen, widgetX, barY);
        ScreenResources.SCROLLBAR_CAP.draw((AbstractGui)screen, widgetX, barY + barSize - 6);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)widgetX, (double)(barY + 6), (double)0.0);
        RenderSystem.scalef((float)1.0f, (float)((float)(barSize - 12) / 16.0f), (float)1.0f);
        ScreenResources.SCROLLBAR_BACKGROUND.draw((AbstractGui)screen, 0, 0);
        RenderSystem.popMatrix();
    }

    public float getYShift() {
        if (!this.active) {
            return 0.0f;
        }
        return (-0.5f + this.position) * (float)(this.span - 200);
    }

    public void tryScroll(int mouseX, int mouseY, int amount) {
        if (mouseX > this.x && mouseX < this.x + 32 && mouseY > this.y && mouseY < this.y + 256) {
            this.position -= 1.0f / this.scale * 0.2f * (float)amount;
            this.position = this.position > 1.0f ? 1.0f : (this.position < 0.0f ? 0.0f : this.position);
        }
    }
}

