/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui.widgets;

import com.simibubi.mightyarchitect.foundation.utility.Keyboard;
import com.simibubi.mightyarchitect.gui.widgets.AbstractSimiWidget;
import com.simibubi.mightyarchitect.gui.widgets.Label;
import java.util.function.Consumer;
import net.minecraft.util.text.TextFormatting;

public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected String title = "Choose an option";
    protected Label displayLabel;
    protected int min = 0;
    protected int max = 1;

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput titled(String title) {
        this.title = title;
        this.updateTooltip();
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        this.writeToLabel();
        return this;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.isHovered) {
            return false;
        }
        int priorState = this.state;
        int step = (int)Math.signum(delta) * (Keyboard.isKeyDown(340) ? 5 : 1);
        this.state += step;
        this.clampState();
        if (priorState != this.state) {
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    protected void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = "" + this.state;
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add(TextFormatting.BLUE + this.title);
    }
}

