/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.IComposerTool;
import com.simibubi.mightyarchitect.foundation.utility.Keyboard;
import com.simibubi.mightyarchitect.foundation.utility.RaycastHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class ComposerToolBase
implements IComposerTool {
    protected String toolModeNoCtrl = null;
    protected String toolModeCtrl = null;
    protected float toolModeYOffset = 0.0f;
    protected float lastToolModeYOffset = 0.0f;
    public static Stack selectedStack;
    public static Room selectedRoom;
    public static Direction selectedFace;
    public static BlockPos selectedPos;
    protected Schematic model;

    @Override
    public void init() {
        this.model = ArchitectManager.getModel();
        this.deselect();
    }

    protected void deselect() {
        selectedStack = null;
        selectedFace = null;
        selectedRoom = null;
        selectedPos = null;
    }

    @Override
    public void updateSelection() {
        this.updateOverlay();
        this.updateSelectedRooms();
    }

    protected void updateSelectedRooms() {
        GroundPlan groundPlan = ArchitectManager.getModel().getGroundPlan();
        BlockPos anchor = ArchitectManager.getModel().getAnchor();
        if (groundPlan.isEmpty()) {
            this.deselect();
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((PlayerEntity)player, 70.0, position -> groundPlan.getRoomAtPos(position.func_177973_b((Vector3i)anchor)) != null);
        if (result.missed()) {
            this.deselect();
            return;
        }
        selectedPos = result.getPos().func_177973_b((Vector3i)anchor);
        selectedRoom = groundPlan.getRoomAtPos(selectedPos);
        selectedStack = groundPlan.getStackAtPos(selectedPos);
        selectedFace = result.getFacing();
    }

    protected void updateOverlay() {
        this.lastToolModeYOffset = this.toolModeYOffset;
        this.toolModeYOffset = Keyboard.isKeyDown(341) ? (this.toolModeYOffset += (12.0f - this.toolModeYOffset) * 0.2f) : (this.toolModeYOffset *= 0.8f);
    }

    @Override
    public void renderOverlay(MatrixStack ms) {
        int color;
        RenderSystem.pushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow mainWindow = mc.func_228018_at_();
        RenderSystem.translated((double)(mainWindow.func_198107_o() / 2), (double)(mainWindow.func_198087_p() / 2 - 3), (double)0.0);
        RenderSystem.translated((double)25.0, (double)(-MathHelper.func_219799_g((float)mc.func_184121_ak(), (float)this.lastToolModeYOffset, (float)this.toolModeYOffset)), (double)0.0);
        if (this.toolModeNoCtrl != null) {
            color = -1;
            if (Keyboard.isKeyDown(341)) {
                color = 1722469631;
            }
            mc.field_71466_p.func_238405_a_(ms, this.toolModeNoCtrl, 0.0f, 0.0f, color);
        }
        if (this.toolModeCtrl != null) {
            color = -1;
            if (!Keyboard.isKeyDown(341)) {
                color = 1722469631;
            }
            mc.field_71466_p.func_238405_a_(ms, this.toolModeCtrl, 0.0f, 12.0f, color);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    protected void status(String message) {
        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(message), true);
    }
}

