/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.foundation.utility.FilesHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;

public class DesignResourceLoader {
    private static final String BASE_PATH = "themes";

    public static Map<DesignLayer, Map<DesignType, Set<Design>>> loadDesignsForTheme(DesignTheme theme) {
        if (theme.isImported()) {
            return DesignResourceLoader.loadExternalDesignsForTheme(theme);
        }
        HashMap<DesignLayer, Map<DesignType, Set<Design>>> designMap = new HashMap<DesignLayer, Map<DesignType, Set<Design>>>();
        theme.getLayers().forEach(layer -> {
            HashMap typeMap = new HashMap();
            theme.getTypes().forEach(type -> {
                String path = "themes/" + theme.getFilePath() + "/" + layer.getFilePath() + "/" + type.getFilePath();
                typeMap.put(type, DesignResourceLoader.importDesigns(theme, layer, type, path));
            });
            designMap.put((DesignLayer)((Object)layer), typeMap);
        });
        designMap.putAll(DesignResourceLoader.loadExternalDesignsForTheme(theme));
        return designMap;
    }

    public static Map<DesignLayer, Map<DesignType, Set<Design>>> loadExternalDesignsForTheme(DesignTheme theme) {
        HashMap<DesignLayer, Map<DesignType, Set<Design>>> designMap = new HashMap<DesignLayer, Map<DesignType, Set<Design>>>();
        boolean isFile = theme.getFilePath().endsWith(".theme") || theme.getFilePath().endsWith(".json");
        Map<DesignLayer, Map<DesignType, Set<CompoundNBT>>> compoundMap = isFile ? DesignResourceLoader.loadThemeFromThemeFile(theme) : DesignResourceLoader.loadThemeFromFolder(theme);
        theme.getLayers().forEach(layer -> {
            if (!compoundMap.containsKey(layer)) {
                return;
            }
            HashMap typeMap = new HashMap();
            theme.getTypes().forEach(type -> {
                if (!((Map)compoundMap.get(layer)).containsKey(type)) {
                    return;
                }
                HashSet designs = new HashSet();
                ((Set)((Map)compoundMap.get(layer)).get(type)).forEach(compound -> designs.add(type.getDesign().fromNBT((CompoundNBT)compound)));
                typeMap.put(type, designs);
            });
            designMap.put((DesignLayer)((Object)layer), typeMap);
        });
        return designMap;
    }

    private static Map<DesignLayer, Map<DesignType, Set<CompoundNBT>>> loadThemeFromThemeFile(DesignTheme theme) {
        CompoundNBT themeFile;
        HashMap<DesignLayer, Map<DesignType, Set<CompoundNBT>>> compoundMap = new HashMap<DesignLayer, Map<DesignType, Set<CompoundNBT>>>();
        CompoundNBT importedThemeFile = new CompoundNBT();
        if (theme.getFilePath().endsWith(".theme")) {
            try {
                InputStream inputStream = Files.newInputStream(Paths.get("themes/" + theme.getFilePath(), new String[0]), StandardOpenOption.READ);
                importedThemeFile = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            importedThemeFile = FilesHelper.loadJsonAsNBT("themes/" + theme.getFilePath());
        }
        if ((themeFile = importedThemeFile).func_74764_b("Designs")) {
            theme.getLayers().forEach(layer -> {
                HashMap typeMap = new HashMap();
                theme.getTypes().forEach(type -> {
                    CompoundNBT tagTypes;
                    HashSet designs = new HashSet();
                    CompoundNBT tagLayers = themeFile.func_74775_l("Designs");
                    if (tagLayers.func_74764_b(layer.name()) && (tagTypes = tagLayers.func_74775_l(layer.name())).func_74764_b(type.name())) {
                        ListNBT tagDesigns = tagTypes.func_150295_c(type.name(), 10);
                        tagDesigns.forEach(tag -> designs.add((CompoundNBT)tag));
                    }
                    typeMap.put(type, designs);
                });
                compoundMap.put((DesignLayer)((Object)layer), typeMap);
            });
        }
        return compoundMap;
    }

    public static Map<DesignLayer, Map<DesignType, Set<CompoundNBT>>> loadThemeFromFolder(DesignTheme theme) {
        HashMap<DesignLayer, Map<DesignType, Set<CompoundNBT>>> compoundMap = new HashMap<DesignLayer, Map<DesignType, Set<CompoundNBT>>>();
        String folderPath = BASE_PATH;
        String themePath = folderPath + "/" + theme.getFilePath();
        if (!Files.exists(Paths.get(themePath, new String[0]), new LinkOption[0]) && !Files.isDirectory(Paths.get(themePath, new String[0]), new LinkOption[0])) {
            return compoundMap;
        }
        theme.getLayers().forEach(layer -> {
            HashMap typeMap = new HashMap();
            theme.getTypes().forEach(type -> {
                String path = folderPath + "/" + theme.getFilePath() + "/" + layer.getFilePath() + "/" + type.getFilePath();
                typeMap.put(type, DesignResourceLoader.importExternalDesigns(theme, layer, type, path));
            });
            compoundMap.put((DesignLayer)((Object)layer), typeMap);
        });
        return compoundMap;
    }

    private static Set<Design> importDesigns(DesignTheme theme, DesignLayer layer, DesignType type, String folderPath) {
        HashSet<Design> designs = new HashSet<Design>();
        for (int index = 0; index < 2048; ++index) {
            String path = folderPath + "/design" + (index == 0 ? "" : "_" + index) + ".json";
            if (TheMightyArchitect.class.getClassLoader().getResource(path) == null) break;
            CompoundNBT designTag = FilesHelper.loadJsonResourceAsNBT(path);
            designs.add(type.getDesign().fromNBT(designTag));
        }
        return designs;
    }

    private static Set<CompoundNBT> importExternalDesigns(DesignTheme theme, DesignLayer layer, DesignType type, String folderPath) {
        HashSet<CompoundNBT> designs = new HashSet<CompoundNBT>();
        if (!Files.exists(Paths.get(folderPath, new String[0]), new LinkOption[0])) {
            return designs;
        }
        try {
            DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(Paths.get(folderPath, new String[0]));
            for (Path path : newDirectoryStream) {
                CompoundNBT designTag = FilesHelper.loadJsonAsNBT(path.toString());
                designs.add(designTag);
            }
            newDirectoryStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return designs;
    }
}

