/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.palette.BlockOrientation;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public class DesignSlice {
    private DesignSliceTrait trait;
    private Palette[][] blocks;
    private BlockOrientation[][] orientations;

    public static DesignSlice fromNBT(CompoundNBT sliceTag) {
        char charAt;
        int x;
        String strip;
        int z;
        DesignSlice slice = new DesignSlice();
        slice.trait = DesignSliceTrait.valueOf(sliceTag.func_74779_i("Trait"));
        String[] strips = sliceTag.func_74779_i("Blocks").split(",");
        int width = strips[0].length();
        int length = strips.length;
        slice.blocks = new Palette[length][width];
        for (z = 0; z < length; ++z) {
            strip = strips[z];
            for (x = 0; x < width; ++x) {
                charAt = strip.charAt(x);
                if (charAt == ' ') continue;
                slice.blocks[z][x] = Palette.getByChar(charAt);
            }
        }
        slice.orientations = new BlockOrientation[length][width];
        if (sliceTag.func_74764_b("Facing")) {
            strips = sliceTag.func_74779_i("Facing").split(",");
            for (z = 0; z < length; ++z) {
                strip = strips[z];
                for (x = 0; x < width; ++x) {
                    charAt = strip.charAt(x);
                    slice.orientations[z][x] = BlockOrientation.valueOf(charAt);
                }
            }
        } else {
            for (z = 0; z < length; ++z) {
                Arrays.fill((Object[])slice.orientations[z], (Object)BlockOrientation.NONE);
            }
        }
        return slice;
    }

    public PaletteBlockInfo getBlockAt(int x, int z, int rotation) {
        return this.getBlockAt(x, z, rotation, false);
    }

    public PaletteBlockInfo getBlockAt(int x, int z, int rotation, boolean mirrorX) {
        Palette palette = this.blocks[z][x];
        if (palette == null) {
            return null;
        }
        BlockOrientation blockOrientation = this.orientations[z][x];
        if (!blockOrientation.hasFacing()) {
            blockOrientation = BlockOrientation.valueOf(blockOrientation.getHalf(), Direction.NORTH);
        }
        PaletteBlockInfo paletteBlockInfo = new PaletteBlockInfo(palette, blockOrientation);
        paletteBlockInfo.afterPosition = BlockOrientation.NORTH.withRotation(rotation);
        if (this.orientations[z][x].hasFacing() && this.orientations[z][x].getFacing().func_176740_k() != Direction.Axis.Y) {
            paletteBlockInfo.forceAxis = true;
        }
        if (rotation % 180 == 0) {
            paletteBlockInfo.mirrorZ = mirrorX;
        } else {
            paletteBlockInfo.mirrorX = mirrorX;
        }
        return paletteBlockInfo;
    }

    public DesignSliceTrait getTrait() {
        return this.trait;
    }

    public Set<Integer> adjustHeigthsList(Set<Integer> heightsList) {
        HashSet<Integer> newHeights = new HashSet<Integer>();
        for (Integer integer : heightsList) {
            switch (this.trait) {
                case Standard: {
                    newHeights.add(integer + 1);
                    break;
                }
                case CloneOnce: {
                    newHeights.add(integer + 1);
                    newHeights.add(integer + 2);
                    break;
                }
                case CloneThrice: {
                    newHeights.add(integer + 1);
                    newHeights.add(integer + 2);
                    newHeights.add(integer + 3);
                    newHeights.add(integer + 4);
                    break;
                }
                case Optional: {
                    newHeights.add(integer);
                    newHeights.add(integer + 1);
                    break;
                }
                case MaskAbove: 
                case MaskBelow: {
                    newHeights.add(integer);
                }
            }
        }
        return newHeights;
    }

    public int adjustDefaultHeight(int defaultHeight) {
        switch (this.trait) {
            case MaskAbove: 
            case MaskBelow: {
                return defaultHeight;
            }
        }
        return defaultHeight + 1;
    }

    public int addToPrintedLayers(List<DesignSlice> toPrint, int currentHeight, int targetHeight) {
        switch (this.trait) {
            case Standard: 
            case MaskAbove: 
            case MaskBelow: {
                toPrint.add(this);
                return currentHeight;
            }
            case Optional: {
                if (currentHeight > targetHeight) {
                    return currentHeight - 1;
                }
                toPrint.add(this);
                return currentHeight;
            }
            case CloneOnce: {
                toPrint.add(this);
                if (currentHeight < targetHeight) {
                    toPrint.add(this);
                    return currentHeight + 1;
                }
                return currentHeight;
            }
            case CloneThrice: {
                int i;
                toPrint.add(this);
                for (i = 0; i < 3 && currentHeight + i < targetHeight; ++i) {
                    toPrint.add(this);
                }
                return currentHeight + i;
            }
        }
        return currentHeight;
    }

    public static enum DesignSliceTrait implements IStringSerializable
    {
        Standard("-> Use this slice once"),
        CloneOnce("-> Duplicate this slice if necessary"),
        CloneThrice("-> Duplicate up to 3 times"),
        Optional("-> Ignore slice if necessary"),
        MaskAbove("-> Slice does not count towards effective Height"),
        MaskBelow("-> Add this slice onto lower layers");

        private String description;

        private DesignSliceTrait(String description) {
            this.description = description;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String getDescription() {
            return this.description;
        }

        public DesignSliceTrait cycle(int amount) {
            DesignSliceTrait[] values = DesignSliceTrait.values();
            return values[(this.ordinal() + amount + values.length) % values.length];
        }
    }
}

