/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design.partials;

import com.simibubi.mightyarchitect.control.design.DesignSlice;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class FlatRoof
extends Design {
    protected int margin;

    @Override
    public Design fromNBT(CompoundNBT compound) {
        FlatRoof flatRoof = new FlatRoof();
        flatRoof.applyNBT(compound);
        flatRoof.margin = compound.func_74762_e("Margin");
        flatRoof.defaultWidth = (flatRoof.defaultWidth - flatRoof.margin) * 2 - 1;
        return flatRoof;
    }

    @Override
    public Design.DesignInstance create(BlockPos anchor, int rotation, int width, int depth) {
        return new Design.DesignInstance(this, anchor, rotation, width, this.size.func_177956_o(), depth);
    }

    @Override
    public boolean fitsVertically(int height) {
        return true;
    }

    @Override
    public boolean fitsHorizontally(int width) {
        return width >= this.defaultWidth;
    }

    @Override
    public void getBlocks(Design.DesignInstance instance, Map<BlockPos, PaletteBlockInfo> blocks) {
        BlockPos pos;
        PaletteBlockInfo block;
        int z;
        int x;
        int y;
        int xShift = this.margin;
        int zShift = this.margin;
        BlockPos position = instance.localAnchor;
        List<DesignSlice> printedSlices = this.selectPrintedLayers(instance.height);
        for (y = 0; y < printedSlices.size(); ++y) {
            for (x = 0; x < this.size.func_177958_n(); ++x) {
                for (z = this.size.func_177952_p() - 1; z < instance.depth - this.size.func_177952_p() + 2 * this.margin; ++z) {
                    block = printedSlices.get(y).getBlockAt(x, 0, instance.rotationY);
                    if (block == null) continue;
                    pos = position.func_177971_a((Vector3i)this.rotateAroundZero(new BlockPos(x - xShift, y + this.yShift, -z + zShift), instance.rotationY));
                    this.putBlock(blocks, pos, block);
                }
            }
        }
        for (y = 0; y < printedSlices.size(); ++y) {
            for (x = this.size.func_177958_n(); x <= instance.width - (this.size.func_177958_n() - this.margin - 1); ++x) {
                for (z = -(instance.depth - 2 * this.size.func_177952_p() + zShift + 1); z < this.size.func_177952_p(); ++z) {
                    block = printedSlices.get(y).getBlockAt(this.size.func_177958_n() - 1, Math.max(z, 0), instance.rotationY);
                    if (block == null) continue;
                    pos = position.func_177971_a((Vector3i)this.rotateAroundZero(new BlockPos(x - xShift, y + this.yShift, z + zShift - this.size.func_177952_p() + 1), instance.rotationY));
                    this.putBlock(blocks, pos, block);
                }
            }
        }
        BlockPos totalShift = new BlockPos(-xShift, this.yShift, zShift - this.size.func_177952_p() + 1);
        BlockPos mirrorShift = new BlockPos(xShift, this.yShift, zShift - this.size.func_177952_p() + 1);
        for (int y2 = 0; y2 < printedSlices.size(); ++y2) {
            DesignSlice layer = printedSlices.get(y2);
            for (int x2 = 0; x2 < this.size.func_177958_n(); ++x2) {
                for (int z2 = 0; z2 < this.size.func_177952_p(); ++z2) {
                    PaletteBlockInfo block2 = layer.getBlockAt(x2, z2, instance.rotationY, false);
                    PaletteBlockInfo blockMirrored = layer.getBlockAt(x2, z2, instance.rotationY, true);
                    if (block2 == null) continue;
                    BlockPos pos2 = this.rotateAroundZero(new BlockPos(x2, y2, z2).func_177971_a((Vector3i)totalShift), instance.rotationY).func_177971_a((Vector3i)position);
                    BlockPos posMirrored = this.rotateAroundZero(new BlockPos(instance.width - x2 - 1, y2, z2).func_177971_a((Vector3i)mirrorShift), instance.rotationY).func_177971_a((Vector3i)position);
                    this.putBlock(blocks, pos2, block2);
                    this.putBlock(blocks, posMirrored, blockMirrored);
                }
            }
        }
    }
}

