/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.jei.villagercrafting;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import sguest.millenairejei.jei.DrawableWithLabel;
import sguest.millenairejei.recipes.villagercrafting.VillagerSlaughterRecipeData;
import sguest.millenairejei.util.UiHelper;

public class VillagerSlaughteringRecipeWrapper
implements IRecipeWrapper {
    private final VillagerSlaughterRecipeData recipeEntry;
    private final DrawableWithLabel culture;
    private final List<DrawableWithLabel> villagers;

    public VillagerSlaughteringRecipeWrapper(VillagerSlaughterRecipeData recipeEntry, IGuiHelper guiHelper) {
        this.recipeEntry = recipeEntry;
        this.culture = UiHelper.toDrawable(recipeEntry.getCulture(), guiHelper);
        this.villagers = recipeEntry.getVillagers().stream().map(v -> UiHelper.toDrawable(v, guiHelper)).collect(Collectors.toList());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.recipeEntry.getOutputs());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        UiHelper.renderIconWithLabel(minecraft, 1, 1, this.culture);
        minecraft.field_71466_p.func_78276_b(this.recipeEntry.getAnimalName(), 1, 21, -1);
        for (int i = 0; i < this.villagers.size(); ++i) {
            UiHelper.renderIconWithLabel(minecraft, 1, 60 + i * 20, this.villagers.get(i));
        }
    }

    public VillagerSlaughterRecipeData getRecipe() {
        return this.recipeEntry;
    }
}

