/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sguest.millenairejei.millenairedata.CultureData;
import sguest.millenairejei.util.DataFileHelper;

public class CultureDataLookup {
    private static CultureDataLookup instance;
    private Map<String, CultureData> cultureInfo = new TreeMap<String, CultureData>(String.CASE_INSENSITIVE_ORDER);

    public static CultureDataLookup getInstance() {
        if (instance == null) {
            instance = new CultureDataLookup();
        }
        return instance;
    }

    private CultureDataLookup() {
    }

    public void loadCultureData(String cultureKey, Path culturePath) {
        Map<String, List<String>> fileData;
        File cultureFile;
        CultureData cultureData = this.cultureInfo.get(cultureKey);
        if (cultureData == null) {
            cultureData = new CultureData();
            this.cultureInfo.put(cultureKey, cultureData);
        }
        if ((cultureFile = culturePath.resolve("culture.txt").toFile()).exists() && (fileData = DataFileHelper.loadDataFile(cultureFile)) != null && fileData.containsKey("icon")) {
            cultureData.setIcon(fileData.get("icon").get(0));
        }
    }

    public Map<String, CultureData> getCultureInfo() {
        return this.cultureInfo;
    }
}

