/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import sguest.millenairejei.millenairedata.CultureLanguageData;
import sguest.millenairejei.util.DataFileHelper;

public class LanguageLookup {
    private static LanguageLookup instance;
    private Map<String, CultureLanguageData> languageData = new TreeMap<String, CultureLanguageData>(String.CASE_INSENSITIVE_ORDER);

    public static LanguageLookup getInstance() {
        if (instance == null) {
            instance = new LanguageLookup();
        }
        return instance;
    }

    private LanguageLookup() {
    }

    public void loadLanguageData(String cultureKey, Path rootFolder) {
        Path languageFolder = rootFolder.resolve("languages");
        if (languageFolder.toFile().exists()) {
            String languageCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            Path specificLanguageFolder = languageFolder.resolve(languageCode);
            boolean specificFound = false;
            if (specificLanguageFolder.toFile().exists()) {
                specificFound = true;
                this.loadLanguage(cultureKey, specificLanguageFolder, false);
            }
            if (languageCode.contains("_")) {
                Path baseLanguageFolder = languageFolder.resolve(languageCode.split("_")[0]);
                this.loadLanguage(cultureKey, baseLanguageFolder, specificFound);
            }
            if (!languageCode.startsWith("en")) {
                Path fallbackLanguageFolder = languageFolder.resolve("en");
                this.loadLanguage(cultureKey, fallbackLanguageFolder, true);
            }
        }
    }

    public CultureLanguageData getLanguageData(String cultureKey) {
        return this.languageData.get(cultureKey);
    }

    private void loadLanguage(String cultureKey, Path languageFolder, boolean isFallback) {
        Map<String, List<String>> fileData;
        File buildingFile;
        Map<String, List<String>> fileData2;
        File languageFile;
        CultureLanguageData cultureLanguage = this.languageData.get(cultureKey);
        if (cultureLanguage == null) {
            cultureLanguage = new CultureLanguageData();
            this.languageData.put(cultureKey, cultureLanguage);
        }
        if ((languageFile = languageFolder.resolve(cultureKey + "_strings.txt").toFile()).exists() && (fileData2 = DataFileHelper.loadDataFile(languageFile)) != null) {
            List<String> fullName;
            List<String> shortName = fileData2.get("culture." + cultureKey);
            if (!(shortName == null || isFallback && cultureLanguage.getShortName() != null)) {
                cultureLanguage.setShortName(shortName.get(0));
            }
            if (!((fullName = fileData2.get("culture.fullname")) == null || isFallback && cultureLanguage.getFullName() != null)) {
                cultureLanguage.setFullName(fullName.get(0));
            }
            for (Map.Entry<String, List<String>> entry : fileData2.entrySet()) {
                if (entry.getKey().startsWith("shop.")) {
                    String shopKey = entry.getKey().split("\\.", 2)[1];
                    List<String> shopName = entry.getValue();
                    if (isFallback && cultureLanguage.getShopName(shopKey) != null) continue;
                    cultureLanguage.setShopName(shopKey, shopName.get(0));
                    continue;
                }
                if (entry.getKey().startsWith("village.")) {
                    String villageKey = entry.getKey().split("\\.", 2)[1];
                    List<String> villageName = entry.getValue();
                    if (isFallback && cultureLanguage.getVillageName(villageKey) != null) continue;
                    cultureLanguage.setVillageName(villageKey, villageName.get(0));
                    continue;
                }
                if (!entry.getKey().startsWith("villager.")) continue;
                String villagerKey = entry.getKey().split("\\.", 2)[1];
                List<String> villagerName = entry.getValue();
                if (isFallback && cultureLanguage.getVillagerName(villagerKey) != null) continue;
                cultureLanguage.setVillagerName(villagerKey, villagerName.get(0));
            }
        }
        if ((buildingFile = languageFolder.resolve(cultureKey + "_buildings.txt").toFile()).exists() && (fileData = DataFileHelper.loadDataFile(buildingFile)) != null) {
            for (Map.Entry<String, List<String>> entry : fileData.entrySet()) {
                String buildingKey = entry.getKey();
                buildingKey = buildingKey.replaceAll("_[a-zA-Z]\\d?$", "");
                cultureLanguage.setBuildingName(buildingKey, entry.getValue().get(0));
            }
        }
    }
}

