/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata.trading;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.trading.BuildingData;
import sguest.millenairejei.util.DataFileHelper;

public class BuildingLookup {
    private static BuildingLookup instance;
    private Map<String, Map<String, BuildingData>> cultureBuildingData = new TreeMap<String, Map<String, BuildingData>>(String.CASE_INSENSITIVE_ORDER);

    public static BuildingLookup getInstance() {
        if (instance == null) {
            instance = new BuildingLookup();
        }
        return instance;
    }

    private BuildingLookup() {
    }

    public void loadData(String cultureKey, Path cultureFolder) {
        Map<String, BuildingData> cultureBuildings = this.cultureBuildingData.get(cultureKey);
        if (cultureBuildings == null) {
            cultureBuildings = new TreeMap<String, BuildingData>(String.CASE_INSENSITIVE_ORDER);
            this.cultureBuildingData.put(cultureKey, cultureBuildings);
        }
        this.loadDataFolder(cultureBuildings, cultureFolder.resolve("buildings"));
        this.loadDataFolder(cultureBuildings, cultureFolder.resolve("lonebuildings"));
    }

    public Map<String, BuildingData> getCultureBuildings(String cultureKey) {
        return this.cultureBuildingData.get(cultureKey);
    }

    private void loadDataFolder(Map<String, BuildingData> cultureBuildings, Path loadingFolder) {
        if (loadingFolder.toFile().exists()) {
            try {
                Files.walk(loadingFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> FilenameUtils.getExtension((String)file.toFile().getName()).equals("txt")).forEach(file -> {
                    File buildingFile = file.toFile();
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(buildingFile);
                    if (fileData != null && fileData.size() == 0) {
                        fileData = this.loadSemicolonFormat(buildingFile);
                    }
                    if (fileData != null) {
                        String buildingKey = FilenameUtils.getBaseName((String)buildingFile.getName());
                        buildingKey = buildingKey.replaceAll("_[a-zA-Z]\\d?$", "");
                        ArrayList<String> shops = new ArrayList<String>();
                        ArrayList<String> subBuildings = new ArrayList<String>();
                        String icon = null;
                        for (Map.Entry<String, List<String>> entry : fileData.entrySet()) {
                            if (entry.getKey().equals("shop") || entry.getKey().endsWith(".shop")) {
                                shops.addAll((Collection<String>)entry.getValue());
                                continue;
                            }
                            if (entry.getKey().equals("subbuilding") || entry.getKey().endsWith(".subbuilding")) {
                                subBuildings.addAll((Collection<String>)entry.getValue());
                                continue;
                            }
                            if (!entry.getKey().equals("icon") && !entry.getKey().endsWith(".icon")) continue;
                            icon = entry.getValue().get(0);
                        }
                        cultureBuildings.put(buildingKey, new BuildingData(shops, subBuildings, icon));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load shops from folder " + loadingFolder, (Throwable)ex);
            }
        }
    }

    private Map<String, List<String>> loadSemicolonFormat(File buildingFile) {
        TreeMap<String, List<String>> fileData = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        try (BufferedReader reader = new BufferedReader(new FileReader(buildingFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] params;
                if (line.length() <= 0 || line.startsWith("//")) continue;
                for (String param : params = line.split(";")) {
                    String[] parts = param.split(":", 2);
                    if (parts.length != 2) continue;
                    ArrayList<String> dataItems = (ArrayList<String>)fileData.get(parts[0]);
                    if (dataItems == null) {
                        dataItems = new ArrayList<String>();
                        fileData.put(parts[0], dataItems);
                    }
                    dataItems.add(parts[1]);
                }
            }
        }
        catch (IOException ex) {
            MillenaireJei.getLogger().error("Failed to load data file " + buildingFile, (Throwable)ex);
            return null;
        }
        return fileData;
    }
}

