/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata.trading;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import sguest.millenairejei.millenairedata.trading.ShopData;
import sguest.millenairejei.util.DataFileHelper;

public class ShopLookup {
    private static ShopLookup instance;
    private Map<String, Map<String, ShopData>> cultureShopInfo = new TreeMap<String, Map<String, ShopData>>(String.CASE_INSENSITIVE_ORDER);

    public static ShopLookup getInstance() {
        if (instance == null) {
            instance = new ShopLookup();
        }
        return instance;
    }

    private ShopLookup() {
    }

    public void loadShopInfo(String cultureKey, Path cultureFolder) {
        Path shopsFolder = cultureFolder.resolve("shops");
        if (shopsFolder.toFile().exists()) {
            File[] shopFiles;
            Map<String, ShopData> cultureShops = this.cultureShopInfo.get(cultureKey);
            if (cultureShops == null) {
                cultureShops = new TreeMap<String, ShopData>(String.CASE_INSENSITIVE_ORDER);
                this.cultureShopInfo.put(cultureKey, cultureShops);
            }
            for (File shopFile : shopFiles = shopsFolder.toFile().listFiles()) {
                String shopKey = FilenameUtils.getBaseName((String)shopFile.getName());
                Map<String, List<String>> shopFileData = DataFileHelper.loadDataFile(shopFile);
                if (shopFileData == null) continue;
                List<String> soldItems = this.getItemsFromFile(shopFileData, "sells");
                List<String> boughtItems = this.getItemsFromFile(shopFileData, "buys");
                boughtItems.addAll(this.getItemsFromFile(shopFileData, "buysoptional"));
                cultureShops.put(shopKey, new ShopData(soldItems, boughtItems));
            }
        }
    }

    public Map<String, ShopData> getCultureShops(String cultureKey) {
        return this.cultureShopInfo.get(cultureKey);
    }

    private List<String> getItemsFromFile(Map<String, List<String>> fileData, String key) {
        ArrayList<String> items = new ArrayList<String>();
        List<String> fileLines = fileData.get(key);
        if (fileLines != null) {
            for (String line : fileLines) {
                Collections.addAll(items, line.split(","));
            }
        }
        return items;
    }
}

