/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata.trading;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.trading.CultureTradedGoods;

public class TradedGoodsLookup {
    private static TradedGoodsLookup instance;
    private Map<String, CultureTradedGoods> cultureData = new TreeMap<String, CultureTradedGoods>(String.CASE_INSENSITIVE_ORDER);

    public static TradedGoodsLookup getInstance() {
        if (instance == null) {
            instance = new TradedGoodsLookup();
        }
        return instance;
    }

    private TradedGoodsLookup() {
    }

    public void loadTradedGoods(String cultureKey, Path cultureFolder) {
        File goodsFile = cultureFolder.resolve("traded_goods.txt").toFile();
        if (goodsFile.exists()) {
            CultureTradedGoods cultureGoods = this.cultureData.get(cultureKey);
            if (cultureGoods == null) {
                cultureGoods = new CultureTradedGoods();
                this.cultureData.put(cultureKey, cultureGoods);
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(goodsFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] values;
                    if ((line = line.trim()).length() <= 0 || line.startsWith("//") || (values = line.split(",")).length < 3) continue;
                    String itemKey = values[0];
                    int sellingPrice = this.parsePrice(values[1]);
                    int buyingPrice = this.parsePrice(values[2]);
                    if (sellingPrice > 0) {
                        cultureGoods.setSellingPrice(itemKey, sellingPrice);
                    }
                    if (buyingPrice <= 0) continue;
                    cultureGoods.setBuyingPrice(itemKey, buyingPrice);
                }
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().warn("Could not load trading information for culture " + cultureKey + " from file " + goodsFile);
            }
        }
    }

    public CultureTradedGoods getCulture(String cultureKey) {
        return this.cultureData.get(cultureKey);
    }

    private int parsePrice(String priceString) {
        if ((priceString = priceString.trim()).length() == 0) {
            return 0;
        }
        if (priceString.contains("*")) {
            String[] priceParts = priceString.split("\\*");
            int value = 1;
            for (String part : priceParts) {
                value *= Integer.parseInt(part);
            }
            return value;
        }
        return Integer.parseInt(priceString);
    }
}

