/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata.trading;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.trading.VillageData;
import sguest.millenairejei.util.DataFileHelper;

public class VillageLookup {
    private static VillageLookup instance;
    private Map<String, Map<String, VillageData>> cultureData = new TreeMap<String, Map<String, VillageData>>(String.CASE_INSENSITIVE_ORDER);

    public static VillageLookup getInstance() {
        if (instance == null) {
            instance = new VillageLookup();
        }
        return instance;
    }

    private VillageLookup() {
    }

    public void LoadVillages(String cultureKey, Path cultureFolder) {
        Path villagesFolder = cultureFolder.resolve("villages");
        if (villagesFolder.toFile().exists()) {
            Map<String, VillageData> cultureVillages = this.cultureData.get(cultureKey);
            if (cultureVillages == null) {
                cultureVillages = new TreeMap<String, VillageData>(String.CASE_INSENSITIVE_ORDER);
                this.cultureData.put(cultureKey, cultureVillages);
            }
            Map<String, VillageData> villageMap = cultureVillages;
            try {
                Files.walk(villagesFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null) {
                        List<String> iconValues = fileData.get("icon");
                        String icon = iconValues == null ? null : iconValues.get(0);
                        ArrayList<String> buildings = new ArrayList<String>();
                        for (String key : new String[]{"centre", "start", "core", "secondary"}) {
                            if (!fileData.containsKey(key)) continue;
                            buildings.addAll((Collection)fileData.get(key));
                        }
                        Map<String, Integer> buyingPrices = this.getPrices("buyingPrice", fileData);
                        Map<String, Integer> sellingPrices = this.getPrices("sellingPrice", fileData);
                        String villageKey = FilenameUtils.getBaseName((String)file.toFile().getName());
                        villageMap.put(villageKey, new VillageData(icon, buildings, buyingPrices, sellingPrices));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load villages for culture " + cultureKey, (Throwable)ex);
            }
        }
    }

    public Map<String, VillageData> getVillages(String cultureKey) {
        return this.cultureData.get(cultureKey);
    }

    private Map<String, Integer> getPrices(String key, Map<String, List<String>> fileData) {
        TreeMap<String, Integer> prices = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        if (fileData.containsKey(key)) {
            for (String dataItem : fileData.get(key)) {
                String[] parts = dataItem.split(",", 2);
                if (parts.length != 2) continue;
                String item = parts[0];
                String[] priceParts = parts[1].split("/", 3);
                int price = 0;
                price = priceParts.length == 3 ? Integer.parseInt(priceParts[0]) * 64 * 64 + Integer.parseInt(priceParts[1]) * 64 + Integer.parseInt(priceParts[2]) : (priceParts.length == 2 ? Integer.parseInt(priceParts[0]) * 64 + Integer.parseInt(priceParts[1]) : Integer.parseInt(priceParts[0]));
                prices.put(item, price);
            }
        }
        return prices;
    }
}

