/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.recipes.painting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import sguest.millenairejei.recipes.painting.PaintingRecipeData;
import sguest.millenairejei.util.ItemHelper;

public class PaintingRecipeLookup {
    private static final String[] colours = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    private static final String[] itemTypes = new String[]{"painted_brick", "stairs_painted_brick", "wall_painted_brick", "slab_painted_brick", "painted_brick_decorated"};
    private final List<PaintingRecipeData> recipes = new ArrayList<PaintingRecipeData>();

    public void buildRecipes() {
        HashMap<String, ItemStack> buckets = new HashMap<String, ItemStack>();
        for (String colour : colours) {
            buckets.put(colour, ItemHelper.getStackFromResource("millenaire:paint_bucket_" + colour));
        }
        for (String itemType : itemTypes) {
            HashMap<String, ItemStack> items = new HashMap<String, ItemStack>();
            for (String colour : colours) {
                items.put(colour, ItemHelper.getStackFromResource("millenaire:" + itemType + "_" + colour));
            }
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(items.values());
            for (Map.Entry entry : items.entrySet()) {
                this.recipes.add(new PaintingRecipeData(itemList, (ItemStack)entry.getValue(), (ItemStack)buckets.get(entry.getKey())));
            }
        }
    }

    public List<PaintingRecipeData> getRecipes() {
        return this.recipes;
    }
}

