/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.recipes.trading;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.CultureData;
import sguest.millenairejei.millenairedata.CultureDataLookup;
import sguest.millenairejei.millenairedata.CultureLanguageData;
import sguest.millenairejei.millenairedata.ItemLookup;
import sguest.millenairejei.millenairedata.LanguageLookup;
import sguest.millenairejei.millenairedata.trading.BuildingData;
import sguest.millenairejei.millenairedata.trading.BuildingLookup;
import sguest.millenairejei.millenairedata.trading.CultureTradedGoods;
import sguest.millenairejei.millenairedata.trading.ShopData;
import sguest.millenairejei.millenairedata.trading.ShopLookup;
import sguest.millenairejei.millenairedata.trading.TradedGoodsLookup;
import sguest.millenairejei.millenairedata.trading.VillageData;
import sguest.millenairejei.millenairedata.trading.VillageLookup;
import sguest.millenairejei.recipes.IconWithLabel;
import sguest.millenairejei.recipes.trading.TradingRecipeData;

public class TradingRecipeLookup {
    private List<TradingRecipeData> buyingRecipes = new ArrayList<TradingRecipeData>();
    private List<TradingRecipeData> sellingRecipes = new ArrayList<TradingRecipeData>();

    public void buildRecipes() {
        ItemLookup itemLookup = ItemLookup.getInstance();
        Map<String, CultureData> cultureInfo = CultureDataLookup.getInstance().getCultureInfo();
        for (Map.Entry<String, CultureData> cultureEntry : cultureInfo.entrySet()) {
            String cultureKey = cultureEntry.getKey();
            try {
                CultureData cultureData = cultureEntry.getValue();
                CultureTradedGoods tradedGoods = TradedGoodsLookup.getInstance().getCulture(cultureKey);
                Map<String, ShopData> cultureShops = ShopLookup.getInstance().getCultureShops(cultureKey);
                CultureLanguageData languageData = LanguageLookup.getInstance().getLanguageData(cultureKey);
                Map<String, VillageData> villageLookupData = VillageLookup.getInstance().getVillages(cultureKey);
                Map<String, BuildingData> cultureBuildings = BuildingLookup.getInstance().getCultureBuildings(cultureKey);
                String cultureName = languageData.getFullName();
                if (cultureName == null) {
                    cultureName = cultureKey;
                }
                ItemStack cultureIcon = null;
                if (cultureData.getIcon() != null) {
                    cultureIcon = ItemLookup.getInstance().getItem(cultureData.getIcon());
                }
                IconWithLabel culture = new IconWithLabel(cultureName, cultureIcon);
                for (Map.Entry<String, VillageData> villageEntry : villageLookupData.entrySet()) {
                    String itemKey;
                    VillageData villageData = villageEntry.getValue();
                    String villageName = languageData.getVillageName(villageEntry.getKey());
                    if (villageName == null) {
                        villageName = villageEntry.getKey();
                    }
                    ItemStack villageIcon = null;
                    if (villageData.getIcon() != null) {
                        villageIcon = ItemLookup.getInstance().getItem(villageData.getIcon());
                    }
                    IconWithLabel village = new IconWithLabel(villageName, villageIcon);
                    TreeMap sellingMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    TreeMap<String, Integer> sellingPrices = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                    TreeMap buyingMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    TreeMap<String, Integer> buyingPrices = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                    for (Map.Entry<String, BuildingData> entry : TradingRecipeLookup.getVillageBuildings(villageData, cultureBuildings).entrySet()) {
                        String buildingKey = entry.getKey();
                        String buildingName = languageData.getBuildingName(buildingKey);
                        if (buildingName == null) {
                            buildingName = buildingKey;
                        }
                        ItemStack icon = null;
                        BuildingData building = entry.getValue();
                        if (building.getIcon() != null) {
                            icon = itemLookup.getItem(building.getIcon());
                        }
                        IconWithLabel recipeBuilding = new IconWithLabel(buildingName, icon);
                        for (String shopKey : building.getShops()) {
                            ShopData shopData = cultureShops.get(shopKey);
                            if (shopData == null) continue;
                            for (String itemKey2 : shopData.getSoldItems()) {
                                Integer sellingPrice = villageData.getSellingPrices().get(itemKey2);
                                if (sellingPrice == null) {
                                    sellingPrice = tradedGoods.getSellingPrice(itemKey2);
                                }
                                if (sellingPrice <= 0) continue;
                                sellingMap.putIfAbsent(itemKey2, new ArrayList());
                                ((List)sellingMap.get(itemKey2)).add(recipeBuilding);
                                sellingPrices.put(itemKey2, sellingPrice);
                            }
                            for (String itemKey2 : shopData.getBoughtItems()) {
                                Integer buyingPrice = villageData.getBuyingPrices().get(itemKey2);
                                if (buyingPrice == null) {
                                    buyingPrice = tradedGoods.getBuyingPrice(itemKey2);
                                }
                                if (buyingPrice <= 0) continue;
                                buyingMap.putIfAbsent(itemKey2, new ArrayList());
                                ((List)buyingMap.get(itemKey2)).add(recipeBuilding);
                                buyingPrices.put(itemKey2, buyingPrice);
                            }
                        }
                    }
                    for (Map.Entry<String, BuildingData> entry : sellingMap.entrySet()) {
                        itemKey = entry.getKey();
                        int sellingPrice = (Integer)sellingPrices.get(itemKey);
                        for (List buildings : Lists.partition((List)((List)((Object)entry.getValue())), (int)3)) {
                            this.buyingRecipes.add(new TradingRecipeData(itemLookup.getItem(itemKey), sellingPrice, culture, village, buildings));
                        }
                    }
                    for (Map.Entry<String, BuildingData> entry : buyingMap.entrySet()) {
                        itemKey = entry.getKey();
                        int buyingPrice = (Integer)buyingPrices.get(itemKey);
                        for (List buildings : Lists.partition((List)((List)((Object)entry.getValue())), (int)3)) {
                            this.sellingRecipes.add(new TradingRecipeData(itemLookup.getItem(itemKey), buyingPrice, culture, village, buildings));
                        }
                    }
                }
            }
            catch (Exception ex) {
                MillenaireJei.getLogger().error("Error loading trading recipes for culture " + cultureKey, (Throwable)ex);
            }
        }
    }

    public List<TradingRecipeData> getBuyingRecipes() {
        return this.buyingRecipes;
    }

    public List<TradingRecipeData> getSellingRecipes() {
        return this.sellingRecipes;
    }

    private static Map<String, BuildingData> getVillageBuildings(VillageData villageData, Map<String, BuildingData> cultureBuildings) {
        TreeMap<String, BuildingData> buildings = new TreeMap<String, BuildingData>(String.CASE_INSENSITIVE_ORDER);
        for (String buildingKey : villageData.getBuildings()) {
            BuildingData building = cultureBuildings.get(buildingKey);
            if (building == null) continue;
            buildings.put(buildingKey, building);
            TradingRecipeLookup.addSubBuildings(building, buildings, cultureBuildings);
        }
        return buildings;
    }

    private static void addSubBuildings(BuildingData mainBuilding, Map<String, BuildingData> buildings, Map<String, BuildingData> cultureBuildings) {
        for (String buildingKey : mainBuilding.getSubBuildings()) {
            BuildingData subBuilding = cultureBuildings.get(buildingKey);
            if (subBuilding == null) continue;
            buildings.put(buildingKey, subBuilding);
            TradingRecipeLookup.addSubBuildings(subBuilding, buildings, cultureBuildings);
        }
    }
}

