/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.api;

import com.robertx22.mine_and_slash.onevent.entity.damage.DamageEventData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;

public class MineAndSlashEvents {

    public static class CollectGearStacksEvent
    extends LivingEvent {
        public List<GearItemData> gears;
        public DamageEventData data;

        public CollectGearStacksEvent(LivingEntity entity, List<GearItemData> gears, DamageEventData data) {
            super(entity);
            this.gears = gears;
            this.data = data;
        }

        public void add(GearItemData data) {
            if (data != null) {
                this.gears.add(data);
            }
        }

        public void add(ItemStack stack) {
            GearItemData data;
            if (CollectGearStacksEvent.isStackValidGear(stack) && (data = Gear.Load(stack)) != null) {
                this.gears.add(data);
            }
        }

        public static boolean isStackValidGear(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            if (stack.func_77984_f()) {
                return !RepairUtils.isItemBroken(stack);
            }
            return true;
        }
    }

    public static class OnStatCalculation
    extends LivingEvent {
        public EntityCap.UnitData data;

        public OnStatCalculation(LivingEntity entity, EntityCap.UnitData data) {
            super(entity);
            this.data = data;
        }
    }

    public static class OnDmgDoneEvent
    extends LivingEvent {
        public DamageEffect data;

        public OnDmgDoneEvent(LivingEntity entity, DamageEffect data) {
            super(entity);
            this.data = data;
        }

        public float getTotalDamage() {
            if (this.data.isDmgAllowed()) {
                DamageEffect.DmgByElement info = this.data.getDmgByElement();
                return info.totalDmg;
            }
            return 0.0f;
        }
    }

    public static class GiveExpEvent
    extends LivingEvent {
        public int experience = 0;
        public EntityCap.UnitData playerCapability;
        public LivingEntity entityKilled;
        public PlayerEntity player;

        public GiveExpEvent(LivingEntity killed, PlayerEntity player, EntityCap.UnitData playerdata, int exp) {
            super((LivingEntity)player);
            this.entityKilled = killed;
            this.player = player;
            this.playerCapability = playerdata;
            this.experience = exp;
            this.setResult(Event.Result.ALLOW);
        }
    }
}

