/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.bases;

import com.robertx22.mine_and_slash.blocks.bases.IOBlock;
import com.robertx22.mine_and_slash.items.misc.ItemCapacitor;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public abstract class BaseTile
extends TileEntity
implements IOBlock,
ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    protected ItemStack[] itemStacks;
    public int ticks = 0;
    public short cookTime = 0;
    public int fuel = 0;
    private static final short COOK_TIME_FOR_COMPLETION = 200;

    public BaseTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public abstract int ticksRequired();

    public abstract void finishCooking();

    public abstract boolean isCooking();

    public abstract int tickRate();

    public abstract void doActionEveryTime();

    public abstract int getCookTime();

    public void func_73660_a() {
        try {
            if (!this.field_145850_b.field_72995_K) {
                ++this.ticks;
                if (this.ticks > this.tickRate()) {
                    this.ticks = 0;
                    this.doActionEveryTime();
                    if (this.isCooking()) {
                        this.cookTime = (short)(this.cookTime + this.tickRate());
                        if (this.cookTime >= this.ticksRequired()) {
                            this.finishCooking();
                            this.cookTime = 0;
                        }
                    } else {
                        this.cookTime = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / 200.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    @Override
    public int[] inputSlots() {
        return new int[0];
    }

    public int[] func_180463_a(Direction side) {
        return this.slots();
    }

    @Override
    public boolean isItemValidOutput(ItemStack stack) {
        return true;
    }

    private int[] slots() {
        int[] ints = new int[this.itemStacks.length];
        for (int i = 0; i < this.itemStacks.length; ++i) {
            ints[i] = i;
        }
        return ints;
    }

    public boolean containsSlot(int index, int[] slots) {
        for (int i : this.inputSlots()) {
            if (i != index) continue;
            return true;
        }
        return false;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (this.isAutomatable() && this.containsSlot(index, this.inputSlots())) {
            return this.isItemValidInput(itemStackIn);
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (this.isAutomatable()) {
            if (stack.func_77973_b() instanceof ItemCapacitor) {
                return false;
            }
            return this.isOutputSlot(index);
        }
        return false;
    }

    public ItemStack func_70301_a(int i) {
        return this.itemStacks[i];
    }

    public ItemStack func_70298_a(int slotIndex, int count) {
        ItemStack itemStackRemoved;
        ItemStack itemStackInSlot = this.func_70301_a(slotIndex);
        if (itemStackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (itemStackInSlot.func_190916_E() <= count) {
            itemStackRemoved = itemStackInSlot;
            this.func_70299_a(slotIndex, ItemStack.field_190927_a);
        } else {
            itemStackRemoved = itemStackInSlot.func_77979_a(count);
            if (itemStackInSlot.func_190916_E() == 0) {
                this.func_70299_a(slotIndex, ItemStack.field_190927_a);
            }
        }
        this.func_70296_d();
        return itemStackRemoved;
    }

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.itemStacks[slotIndex] = itemstack;
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_174888_l() {
        Arrays.fill(this.itemStacks, ItemStack.field_190927_a);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return true;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(slotIndex, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public static boolean isItemValidForFuelSlot(ItemStack itemStack) {
        return true;
    }

    public static boolean isItemValidForInputSlot(ItemStack itemStack) {
        return true;
    }

    public static boolean isItemValidForOutputSlot(ItemStack itemStack) {
        return false;
    }

    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        ListNBT dataForAllSlots = new ListNBT();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i].func_190926_b()) continue;
            CompoundNBT dataForThisSlot = new CompoundNBT();
            dataForThisSlot.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(dataForThisSlot);
            dataForAllSlots.add((Object)dataForThisSlot);
        }
        parentNBTTagCompound.func_218657_a("Items", (INBT)dataForAllSlots);
        parentNBTTagCompound.func_74768_a("ticks", this.ticks);
        parentNBTTagCompound.func_74777_a("CookTime", this.cookTime);
        parentNBTTagCompound.func_74768_a("fuel", this.fuel);
        return parentNBTTagCompound;
    }

    public void func_145839_a(CompoundNBT nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        int NBT_TYPE_COMPOUND = 10;
        ListNBT dataForAllSlots = nbtTagCompound.func_150295_c("Items", 10);
        Arrays.fill(this.itemStacks, ItemStack.field_190927_a);
        for (int i = 0; i < dataForAllSlots.size(); ++i) {
            CompoundNBT dataForOneSlot = dataForAllSlots.func_150305_b(i);
            byte slotNumber = dataForOneSlot.func_74771_c("Slot");
            if (slotNumber < 0 || slotNumber >= this.itemStacks.length) continue;
            this.itemStacks[slotNumber] = ItemStack.func_199557_a((CompoundNBT)dataForOneSlot);
        }
        this.cookTime = nbtTagCompound.func_74765_d("CookTime");
        this.ticks = nbtTagCompound.func_74762_e("ticks");
        this.fuel = nbtTagCompound.func_74762_e("fuel");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT updateTagDescribingTileEntityState = this.func_189517_E_();
        boolean METADATA = false;
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, updateTagDescribingTileEntityState);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT updateTagDescribingTileEntityState = pkt.func_148857_g();
        this.handleUpdateTag(updateTagDescribingTileEntityState);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }
}

