/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.item_modify_station;

import com.robertx22.mine_and_slash.blocks.bases.BaseTile;
import com.robertx22.mine_and_slash.blocks.item_modify_station.ContainerGearModify;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.currency.base.IAddsInstability;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModTileEntities;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.IInstability;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;

public class TileGearModify
extends BaseTile {
    public static final int INPUT_SLOTS_COUNT = 2;
    public static final int OUTPUT_SLOTS_COUNT = 1;
    public static final int TOTAL_SLOTS_COUNT = 3;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int FIRST_OUTPUT_SLOT = 2;
    private static final short COOK_TIME_FOR_COMPLETION = 40;

    @Override
    public boolean isAutomatable() {
        return false;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return true;
    }

    @Override
    public int getCookTime() {
        return 40;
    }

    @Override
    public boolean isOutputSlot(int slot) {
        return false;
    }

    public ResultItem getSmeltingResultForItem(ItemStack stack) {
        LocReqContext context = this.getLocReqContext();
        if (!context.isValid()) {
            return new ResultItem(ItemStack.field_190927_a, ModifyResult.NONE);
        }
        if (context.effect != null) {
            if (context.effect.canItemBeModified(context)) {
                ItemStack copy = context.stack.func_77946_l();
                copy = context.effect.ModifyItem(copy, context.Currency);
                ICommonDataItem data = ICommonDataItem.load(copy);
                if (((Boolean)ModConfig.INSTANCE.Server.ENABLE_CURRENCY_ITEMS_INSTABILITY_SYSTEM.get()).booleanValue() && data instanceof IInstability && context.Currency.func_77973_b() instanceof IAddsInstability) {
                    IInstability insta = (IInstability)((Object)data);
                    IAddsInstability addsInta = (IAddsInstability)context.Currency.func_77973_b();
                    if (insta.isInstabilityCapReached() && !addsInta.canBeUsedAtFullInstability()) {
                        copy = ItemStack.field_190927_a;
                    } else {
                        float breakChance;
                        boolean broke = false;
                        if (insta.usesBreakChance() && addsInta.activatesBreakRoll() && RandomUtils.roll(breakChance = (addsInta.additionalBreakChance() + insta.getBreakChance()) * addsInta.breakChanceMulti())) {
                            copy = new ItemStack((IItemProvider)Items.field_151016_H);
                            broke = true;
                            return new ResultItem(new ItemStack((IItemProvider)Items.field_151016_H), ModifyResult.BREAK);
                        }
                        if (!broke) {
                            insta.increaseInstability(addsInta.instabilityAddAmount());
                            data.saveToStack(copy);
                        }
                    }
                }
                return new ResultItem(copy, ModifyResult.SUCCESS);
            }
            return new ResultItem(ItemStack.field_190927_a, ModifyResult.NONE);
        }
        return new ResultItem(ItemStack.field_190927_a, ModifyResult.NONE);
    }

    public LocReqContext getLocReqContext() {
        ItemStack gearStack = this.GearSlot();
        ItemStack craftStack = this.CraftItemSlot();
        LocReqContext context = new LocReqContext(gearStack, craftStack, this);
        return context;
    }

    public ItemStack GearSlot() {
        return this.itemStacks[0];
    }

    public ItemStack CraftItemSlot() {
        return this.itemStacks[1];
    }

    public ItemStack OutputSot() {
        return this.itemStacks[2];
    }

    public void setOutputSot(ItemStack stack) {
        this.itemStacks[2] = stack;
    }

    public TileGearModify() {
        super((TileEntityType)ModTileEntities.GEAR_MODIFY.get());
        this.itemStacks = new ItemStack[3];
        this.func_174888_l();
    }

    @Override
    public int ticksRequired() {
        return 40;
    }

    @Override
    public void finishCooking() {
        this.modifyItem();
    }

    @Override
    public boolean isCooking() {
        return this.canModifyItem();
    }

    @Override
    public int tickRate() {
        return 1;
    }

    @Override
    public void doActionEveryTime() {
    }

    @Override
    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / (double)this.getCookTime();
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    private ResultItem getResult() {
        return this.getSmeltingResultForItem(this.GearSlot());
    }

    private boolean canModifyItem() {
        ItemStack gear = this.GearSlot();
        if (gear.func_190926_b()) {
            return false;
        }
        if (this.getSmeltingResultForItem((ItemStack)gear).stack.func_190926_b()) {
            return false;
        }
        return this.OutputSot().func_190926_b();
    }

    private boolean modifyItem() {
        if (this.canModifyItem()) {
            ResultItem result = this.getResult();
            this.GearSlot().func_190918_g(1);
            this.setOutputSot(result.stack.func_77946_l());
            this.OutputSot().func_190920_e(1);
            result.stack = ItemStack.field_190927_a;
            this.CraftItemSlot().func_190918_g(1);
            this.func_70296_d();
            if (result.resultEnum.equals((Object)ModifyResult.BREAK)) {
                SoundUtils.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187539_bB, 1.0f, 1.0f);
                ParticleEnum.sendToClients(this.field_174879_c.func_177984_a(), this.field_145850_b, new ParticlePacketData(this.field_174879_c.func_177984_a(), ParticleEnum.AOE).radius(0.5f).type((ParticleType)ParticleTypes.field_197598_I).motion(new Vec3d(0.0, 0.0, 0.0)).amount(5));
            } else if (result.resultEnum.equals((Object)ModifyResult.SUCCESS)) {
                SoundUtils.ding(this.field_145850_b, this.field_174879_c);
                ParticleEnum.sendToClients(this.field_174879_c.func_177984_a(), this.field_145850_b, new ParticlePacketData(this.field_174879_c.func_177984_a(), ParticleEnum.AOE).radius(0.5f).type((ParticleType)ParticleTypes.field_218420_D).amount(15));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Container createMenu(int num, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerGearModify(num, inventory, (IInventory)this, this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return CLOC.blank("block.mmorpg.modify_station");
    }

    static class ResultItem {
        ItemStack stack;
        ModifyResult resultEnum;

        public ResultItem(ItemStack stack, ModifyResult resultEnum) {
            this.stack = stack;
            this.resultEnum = resultEnum;
        }
    }

    public static enum ModifyResult {
        BREAK,
        SUCCESS,
        NONE;

    }
}

