/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.map_device;

import com.robertx22.mine_and_slash.blocks.bases.BaseTile;
import com.robertx22.mine_and_slash.blocks.map_device.ContainerMapDevice;
import com.robertx22.mine_and_slash.blocks.slots.FuelSlot;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.items.misc.ItemMap;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModTileEntities;
import com.robertx22.mine_and_slash.saveclasses.dungeon_dimension.DungeonDimensionData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;

public class TileMapDevice
extends BaseTile {
    public static final int size = 1;
    public static int MaximumFuel = 50000;

    @Override
    public boolean isAutomatable() {
        return false;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return false;
    }

    public ItemStack MapSlot() {
        return this.itemStacks[2];
    }

    public TileMapDevice() {
        super((TileEntityType)ModTileEntities.MAP_DEVICE.get());
        this.itemStacks = new ItemStack[1];
        this.func_174888_l();
    }

    @Override
    public boolean isOutputSlot(int slot) {
        return false;
    }

    @Override
    public int ticksRequired() {
        return 0;
    }

    @Override
    public void finishCooking() {
    }

    @Override
    public boolean isCooking() {
        return false;
    }

    @Override
    public int tickRate() {
        return 10;
    }

    @Override
    public void doActionEveryTime() {
        int val;
        ItemStack fuel = this.itemStacks[0];
        if (this.fuel < MaximumFuel && !fuel.func_190926_b() && (val = FuelSlot.FUEL_VALUES.getOrDefault(fuel.func_77973_b(), 0).intValue()) > 0) {
            this.fuel += val;
            fuel.func_190918_g(1);
        }
    }

    @Override
    public int getCookTime() {
        return 2;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    private boolean summonPortals(MapItemData map) {
        if (this.field_145850_b == null || this.field_145850_b.func_201675_m() == null || this.field_145850_b.func_201675_m() instanceof IWP) {
            return false;
        }
        BlockPos p = this.field_174879_c;
        this.field_145850_b.func_184148_a(null, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 0.6f, 0.0f);
        this.field_145850_b.func_184148_a(null, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), SoundEvents.field_187812_eh, SoundCategory.BLOCKS, 0.4f, 0.0f);
        try {
            DimensionType type = MapManager.getDungeonDimensionType();
            ChunkPos cpos = Load.world(MapManager.getWorld(type)).getData().randomFree();
            String dungeonID = DungeonDimensionData.getId(cpos);
            Load.world(MapManager.getWorld(type)).init(map, cpos);
            if (!WorldUtils.isMapWorld((IWorld)this.field_145850_b)) {
                BlockPos pos = this.field_174879_c.func_177964_d(4);
                Boolean spawnedPortal1 = ItemMap.summonPortal(p, map, this.field_145850_b, pos, type, dungeonID);
                BlockPos pos1 = this.field_174879_c.func_177970_e(4);
                Boolean spawnedPortal2 = ItemMap.summonPortal(p, map, this.field_145850_b, pos1, type, dungeonID);
                BlockPos pos2 = this.field_174879_c.func_177965_g(4);
                Boolean spawnedPortal3 = ItemMap.summonPortal(p, map, this.field_145850_b, pos2, type, dungeonID);
                BlockPos pos3 = this.field_174879_c.func_177985_f(4);
                Boolean spawnedPortal4 = ItemMap.summonPortal(p, map, this.field_145850_b, pos3, type, dungeonID);
                if (!(spawnedPortal1.booleanValue() || spawnedPortal2.booleanValue() || spawnedPortal3.booleanValue() || spawnedPortal4.booleanValue())) {
                    AxisAlignedBB aab = new AxisAlignedBB(this.func_174877_v()).func_186662_g(10.0);
                    this.field_145850_b.func_217357_a(ServerPlayerEntity.class, aab).forEach(x -> x.func_145747_a(Chats.NoSpaceForPortal.locName()));
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.func_70296_d();
        return true;
    }

    public void sacrificeMap(PlayerEntity player, MapItemData mapdata, ItemStack map) {
        if (!this.hasEnoughFuel()) {
            player.func_145747_a((ITextComponent)new SText("Not enough fuel"));
            return;
        }
        boolean summoned = this.summonPortals(mapdata);
        if (summoned) {
            this.spendFuelForActivation();
            mapdata.setupPlayerMapData(this.field_174879_c, player);
            map.func_190918_g(1);
        }
    }

    public boolean hasEnoughFuel() {
        return this.fuel > this.getFuelNeeded();
    }

    public void spendFuelForActivation() {
        this.fuel -= this.getFuelNeeded();
    }

    public int getFuelNeeded() {
        return (Integer)ModConfig.INSTANCE.Server.FUEL_NEEDED_PER_MAP_ACTIVATION.get();
    }

    public ITextComponent func_145748_c_() {
        return CLOC.blank("block.mmorpg.map_device");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMapDevice(i, playerInventory, (IInventory)this, this.field_174879_c);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
    }
}

