/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.repair_station;

import com.robertx22.mine_and_slash.blocks.bases.BaseTile;
import com.robertx22.mine_and_slash.blocks.repair_station.ContainerGearRepair;
import com.robertx22.mine_and_slash.blocks.slots.FuelSlot;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.items.misc.ItemCapacitor;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModTileEntities;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class TileGearRepair
extends BaseTile {
    public static int MaximumFuel = 50000;
    public static final int FUEL_SLOTS_COUNT = 1;
    public static final int INPUT_SLOTS_COUNT = 5;
    public static final int OUTPUT_SLOTS_COUNT = 5;
    public static final int TOTAL_SLOTS_COUNT = 12;
    public static final int FIRST_FUEL_SLOT = 0;
    public static final int FIRST_INPUT_SLOT = 1;
    public static final int FIRST_OUTPUT_SLOT = 6;
    public static final int FIRST_CAPACITOR_SLOT = 11;
    private static final short COOK_TIME_FOR_COMPLETION = 100;

    @Override
    public boolean isAutomatable() {
        return true;
    }

    @Override
    public boolean isItemValidInput(ItemStack stack) {
        return true;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (this.isAutomatable() && this.containsSlot(index, this.inputSlots())) {
            return this.isItemValidInput(itemStackIn);
        }
        return 0 == index && (direction == Direction.NORTH || direction == Direction.EAST || direction == Direction.SOUTH || direction == Direction.WEST);
    }

    @Override
    public int[] inputSlots() {
        int[] ints = new int[5];
        for (int i = 0; i < 5; ++i) {
            ints[i] = 1 + i;
        }
        return ints;
    }

    @Override
    public int getCookTime() {
        ItemCapacitor cap = this.getCapacitor();
        if (cap != null) {
            return (int)(100.0f * cap.GetSpeedMultiplier().floatValue());
        }
        return 100;
    }

    @Override
    public boolean isOutputSlot(int slot) {
        return slot >= 6 && slot <= 11;
    }

    public ItemCapacitor getCapacitor() {
        Item item;
        if (!this.itemStacks[11].func_190926_b() && (item = this.itemStacks[11].func_77973_b()) instanceof ItemCapacitor) {
            return (ItemCapacitor)item;
        }
        return null;
    }

    public ItemStack getSmeltingResultForItem(ItemStack stack) {
        ICommonDataItem data;
        if (stack.func_77973_b().func_77645_m() && (data = ICommonDataItem.load(stack)) != null) {
            ItemStack copy = stack.func_77946_l();
            int dmg = copy.func_77952_i() - this.fuel;
            if (dmg < 0) {
                dmg = 0;
            }
            RepairUtils.setDamage(copy, dmg);
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    public TileGearRepair() {
        super((TileEntityType)ModTileEntities.GEAR_REPAIR.get());
        this.itemStacks = new ItemStack[12];
        this.func_174888_l();
    }

    public double fractionOfFuelRemaining(int fuelSlot) {
        if (this.fuel <= 0) {
            return 0.0;
        }
        double fraction = (double)this.fuel / (double)MaximumFuel;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    @Override
    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / (double)this.getCookTime();
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    @Override
    public int ticksRequired() {
        return this.getCookTime();
    }

    @Override
    public void finishCooking() {
        this.smeltItem();
        ParticleEnum.sendToClients(this.field_174879_c.func_177984_a(), this.field_145850_b, new ParticlePacketData(this.field_174879_c.func_177984_a(), ParticleEnum.AOE).radius(0.5f).type((ParticleType)ParticleTypes.field_218420_D).amount(15));
    }

    @Override
    public boolean isCooking() {
        return this.canSmelt();
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public void doActionEveryTime() {
        this.burnFuel();
    }

    private int burnFuel() {
        int burningCount = 0;
        boolean inventoryChanged = false;
        for (int i = 0; i < 1; ++i) {
            int fuelgained;
            int fuelSlotNumber = i + 0;
            if (this.fuel >= MaximumFuel || this.itemStacks[fuelSlotNumber].func_190926_b() || (fuelgained = FuelSlot.FUEL_VALUES.getOrDefault(this.itemStacks[fuelSlotNumber].func_77973_b(), 0).intValue()) <= 0) continue;
            this.fuel += fuelgained;
            this.itemStacks[fuelSlotNumber].func_190918_g(1);
            ++burningCount;
            inventoryChanged = true;
            if (this.itemStacks[fuelSlotNumber].func_190916_E() != 0) continue;
            this.itemStacks[fuelSlotNumber] = this.itemStacks[fuelSlotNumber].func_77973_b().getContainerItem(this.itemStacks[fuelSlotNumber]);
        }
        if (inventoryChanged) {
            this.func_70296_d();
        }
        return burningCount;
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        Item item;
        if (this.fuel < 1) {
            return false;
        }
        Integer firstSuitableInputSlot = null;
        Integer firstOuputSlot = null;
        ItemStack result = ItemStack.field_190927_a;
        int fuelNeeded = 0;
        float fuelMulti = 1.0f;
        if (!this.itemStacks[11].func_190926_b() && (item = this.itemStacks[11].func_77973_b()) instanceof ItemCapacitor) {
            fuelMulti = ((ItemCapacitor)item).GetFuelMultiplier().floatValue();
        }
        for (int inputSlot = 1; inputSlot < 6; ++inputSlot) {
            if (this.itemStacks[inputSlot].func_190926_b()) continue;
            fuelNeeded = (int)((double)this.itemStacks[inputSlot].func_77952_i() * (Double)ModConfig.INSTANCE.Server.REPAIR_FUEL_NEEDED_MULTI.get());
            if ((fuelNeeded = (int)((float)fuelNeeded * fuelMulti)) > this.fuel) {
                fuelNeeded = this.fuel;
            }
            if ((result = fuelNeeded <= this.fuel ? this.getSmeltingResultForItem(this.itemStacks[inputSlot]) : ItemStack.field_190927_a).func_190926_b()) continue;
            for (int outputSlot = 6; outputSlot < 11; ++outputSlot) {
                int combinedSize;
                ItemStack outputStack = this.itemStacks[outputSlot];
                if (outputStack.func_190926_b()) {
                    firstSuitableInputSlot = inputSlot;
                    firstOuputSlot = outputSlot;
                    break;
                }
                if (outputStack.func_77973_b() != result.func_77973_b() || !ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)result) || (combinedSize = this.itemStacks[outputSlot].func_190916_E() + result.func_190916_E()) > this.func_70297_j_() || combinedSize > this.itemStacks[outputSlot].func_77976_d()) continue;
                firstSuitableInputSlot = inputSlot;
                firstOuputSlot = outputSlot;
                break;
            }
            if (firstSuitableInputSlot != null) break;
        }
        if (firstSuitableInputSlot == null) {
            return false;
        }
        if (!performSmelt) {
            return true;
        }
        this.itemStacks[firstSuitableInputSlot].func_190918_g(1);
        if (this.itemStacks[firstSuitableInputSlot].func_190916_E() <= 0) {
            this.itemStacks[firstSuitableInputSlot.intValue()] = ItemStack.field_190927_a;
        }
        if (this.itemStacks[firstOuputSlot].func_190926_b()) {
            this.itemStacks[firstOuputSlot.intValue()] = result.func_77946_l();
        } else {
            int newStackSize = this.itemStacks[firstOuputSlot].func_190916_E() + result.func_190916_E();
            this.itemStacks[firstOuputSlot].func_190920_e(newStackSize);
        }
        this.fuel = (int)((float)this.fuel - (float)fuelNeeded * fuelMulti);
        this.func_70296_d();
        return true;
    }

    public ITextComponent func_145748_c_() {
        return CLOC.blank("block.mmorpg.repair_station");
    }

    @Nullable
    public Container createMenu(int num, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerGearRepair(num, inventory, (IInventory)this, this.func_174877_v());
    }
}

