/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.blocks.scrabble;

import com.electronwill.nightconfig.core.utils.StringUtils;
import com.robertx22.mine_and_slash.database.loot_crates.bases.LootCrate;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModBlocks;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModTileEntities;
import com.robertx22.mine_and_slash.new_content.chests.MapChestBlock;
import com.robertx22.mine_and_slash.new_content.chests.MapChestTile;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ScrabbleTile
extends TileEntity
implements ITickableTileEntity {
    String letters = "";
    int attemptsLeft = 3;
    static char[] alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static char[] nonWovels = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
    static char[] wovels = new char[]{'a', 'e', 'i', 'o', 'u'};
    public static List<String> WORDS = new ArrayList<String>();
    public static List<String> LONG_WORDS = new ArrayList<String>();

    public ScrabbleTile() {
        super((TileEntityType)ModTileEntities.SCRABBLE.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.letters.isEmpty()) {
            this.letters = ScrabbleTile.genRandomLetters();
        }
    }

    public void tryGuessWord(String word) {
        word = word.toLowerCase(Locale.ROOT);
        ParticlePacketData data = new ParticlePacketData(this.field_174879_c, ParticleEnum.AOE).type((ParticleType)ParticleTypes.field_197607_R).amount(50).radius(1.0f);
        if (ScrabbleTile.usesAllowedLetters(word, this.letters) && ScrabbleTile.isInDict(word)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, ((MapChestBlock)ModBlocks.MAP_CHEST.get()).func_176223_P());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c);
            ParticleEnum.sendToClients(this.field_174879_c, this.field_145850_b, data.type((ParticleType)ParticleTypes.field_197632_y));
            SoundUtils.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187915_go, 1.0f, 1.0f);
            if (tile instanceof MapChestTile) {
                MapChestTile chest = (MapChestTile)tile;
                NonNullList genItems = NonNullList.func_191196_a();
                int amount = ScrabbleTile.getItemRewardAmount(word, this.letters);
                amount = MathHelper.func_76125_a((int)amount, (int)1, (int)27);
                for (int i = 0; i < amount; ++i) {
                    LootCrate crate = SlashRegistry.LootCrates().random();
                    crate.generateItems(new LootInfo(this.field_145850_b.func_201672_e(), this.field_174879_c)).forEach(x -> genItems.add(x));
                }
                chest.addItems((NonNullList<ItemStack>)genItems);
            }
            return;
        }
        if (this.attemptsLeft > 1) {
            ParticleEnum.sendToClients(this.field_174879_c, this.field_145850_b, data.type((ParticleType)ParticleTypes.field_197607_R));
            SoundUtils.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187913_gm, 1.0f, 1.0f);
        } else {
            ParticleEnum.sendToClients(this.field_174879_c, this.field_145850_b, data.type((ParticleType)ParticleTypes.field_197631_x).motion(new Vec3d(0.0, 0.0, 0.0)));
            SoundUtils.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187539_bB, 1.0f, 1.0f);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        }
        --this.attemptsLeft;
    }

    public static int getItemRewardAmount(String word, String letters) {
        float score = ScrabbleTile.getScoreOfWordForLetters(word, letters);
        boolean isSameLength = word.length() == letters.length();
        int amount = (int)(3.0f * score);
        if (isSameLength) {
            amount *= 2;
        }
        if (word.length() < 4) {
            amount = (int)((double)amount * 0.5);
        }
        return amount;
    }

    public static float getScoreOfWordForLetters(String word, String letters) {
        return (float)ScrabbleTile.getScoreOfWord(word) / (float)ScrabbleTile.getScoreOfWord(ScrabbleTile.getHighestScoreWord(letters));
    }

    public static int getScoreOfWord(String word) {
        return word.length();
    }

    public static String getHighestScoreWord(String letters) {
        String best = WORDS.stream().filter(w -> ScrabbleTile.usesAllowedLetters(w, letters)).max(Comparator.comparingInt(x -> ScrabbleTile.getScoreOfWord(x))).get();
        return best;
    }

    public static String genRandomLetters() {
        String letters = "";
        for (int tries = 0; !ScrabbleTile.areLettersSuitable(letters) || tries < 500; ++tries) {
            letters = RandomUtils.randomFromList(LONG_WORDS);
        }
        letters = ScrabbleTile.scramble(new Random(), letters);
        return letters;
    }

    public static String scramble(Random random, String inputString) {
        char[] a = inputString.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            int j = random.nextInt(a.length);
            char temp = a[i];
            a[i] = a[j];
            a[j] = temp;
        }
        return new String(a);
    }

    public static boolean areLettersSuitable(String letters) {
        if (letters.length() < 2) {
            return false;
        }
        int words = 0;
        Set<ImmutablePair<String, Integer>> pairs = ScrabbleTile.getPairs(letters);
        for (String x : WORDS) {
            if (x.length() <= 2 || !ScrabbleTile.usesAllowedLetters(x, letters, pairs)) continue;
            ++words;
        }
        return words > 3 && words < 5 * letters.length();
    }

    public static Set<ImmutablePair<String, Integer>> getPairs(String letters) {
        HashSet<ImmutablePair<String, Integer>> pairs = new HashSet<ImmutablePair<String, Integer>>();
        for (int i = 0; i < letters.length(); ++i) {
            String letter = String.valueOf(letters.charAt(i));
            int count = ScrabbleTile.countLetter(letters, letter);
            pairs.add((ImmutablePair<String, Integer>)ImmutablePair.of((Object)letter, (Object)count));
        }
        return pairs;
    }

    public static boolean usesAllowedLetters(String word, String letters) {
        Set<ImmutablePair<String, Integer>> pairs = ScrabbleTile.getPairs(letters);
        return ScrabbleTile.usesAllowedLetters(word, letters, pairs);
    }

    public static boolean usesAllowedLetters(String word, String letters, Set<ImmutablePair<String, Integer>> pairs) {
        for (int i = 0; i < word.length(); ++i) {
            String letter = String.valueOf(word.charAt(i));
            if (letters.contains(letter)) continue;
            return false;
        }
        for (ImmutablePair<String, Integer> pair : pairs) {
            int count = ScrabbleTile.countLetter(word, (String)pair.left);
            if (count <= (Integer)pair.right) continue;
            return false;
        }
        return true;
    }

    public static int countLetter(String string, String letter) {
        int count = 0;
        for (int c = 0; c < string.length(); ++c) {
            String l = String.valueOf(string.charAt(c));
            if (!l.equals(letter)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isInDict(String word) {
        return WORDS.contains(word);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("letters", this.letters);
        nbt.func_74768_a("attempts", this.attemptsLeft);
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.letters = nbt.func_74779_i("letters");
        this.attemptsLeft = nbt.func_74762_e("attempts");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT updateTagDescribingTileEntityState = this.func_189517_E_();
        boolean METADATA = false;
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, updateTagDescribingTileEntityState);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT updateTagDescribingTileEntityState = pkt.func_148857_g();
        this.handleUpdateTag(updateTagDescribingTileEntityState);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public static void loadWordList() {
        InputStream input = MMORPG.class.getClassLoader().getResourceAsStream("assets\\mmorpg\\word_list.txt");
        try {
            String file = IOUtils.toString((InputStream)input, (String)"utf-8");
            WORDS = StringUtils.splitLines((String)file);
            WORDS = WORDS.stream().filter(x -> x != null && !x.isEmpty()).map(x -> x.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
            LONG_WORDS = WORDS.stream().filter(x -> x.length() > 5).collect(Collectors.toList());
            System.out.println("Loaded " + WORDS.size() + " words to the dictionary.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

