/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.commands.misc;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.mine_and_slash.commands.CommandRefs;
import com.robertx22.mine_and_slash.commands.suggestions.ModsWithItemsSuggestions;
import com.robertx22.mine_and_slash.data_generation.compatible_items.CompatibleItem;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.onevent.data_gen.providers.SlashDataProvider;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SerializationUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;

public class GenDefaultCompItemsOfMod {
    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate").requires(e -> e.func_197034_c(2))).then(Commands.func_197057_a((String)"compatible_items").then(Commands.func_197056_a((String)"mod", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ModsWithItemsSuggestions()).executes(ctx -> GenDefaultCompItemsOfMod.run((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"mod")))))));
    }

    private static int run(CommandSource source, String mod) {
        try {
            ArrayList list = new ArrayList();
            ForgeRegistries.ITEMS.forEach(x -> {
                if (x.getRegistryName() != null && mod.equals(x.getRegistryName().func_110624_b())) {
                    SlashRegistry.GearTypes().getList().forEach(t -> {
                        if (GearItemSlot.isGearOfThisType(t, x)) {
                            String id = x.getRegistryName().toString();
                            CompatibleItem comp = new CompatibleItem();
                            comp.item_type = t.GUID();
                            comp.item_id = id;
                            comp.guid = t.GUID() + ":" + id;
                            list.add(comp);
                        }
                    });
                }
            });
            list.forEach(x -> GenDefaultCompItemsOfMod.output(x, mod));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            source.func_197035_h().func_145747_a((ITextComponent)new SText("Outputted All auto generated default compatible item files to: " + TextFormatting.GREEN + GenDefaultCompItemsOfMod.folder(mod)));
            source.func_197035_h().func_145747_a((ITextComponent)new SText(TextFormatting.RED + "Do note this is prone to error. Some gear types can't be found automatically, and others might be wrong. But it should work for most things."));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 1;
    }

    static String folder(String mod) {
        return SerializationUtils.CONFIG_PATH + "generated/" + mod + "/";
    }

    static void output(CompatibleItem item, String mod) {
        try {
            Path path = Paths.get(GenDefaultCompItemsOfMod.folder(mod), new String[0]).resolve(item.getFileName() + ".json");
            String json = SlashDataProvider.GSON.toJson((JsonElement)item.toJson());
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String filename = item.item_type + "_" + path.getFileName();
            SerializationUtils.makeFileAndDirAndWrite(path.getParent().toString(), filename.toString(), json, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

